/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: kernel.cpp,v 1.7 2003/12/24 07:40:42 takayuki Exp $
 */

#include "stdafx.h"
#include "devicemanager.h"
#include "kernel.h"

/////////////////////////////////////////////////////////////////////////////
// CKernel

CKernel::CKernel()
{
	Valid = _Module.AttachKernel(this);
}

CKernel::~CKernel()
{
	_Module.DetachKernel(this);
}

STDMETHODIMP CKernel::IsValid(BOOL *valid)
{
	*valid = Valid ? TRUE : FALSE;
	return S_OK;
}

STDMETHODIMP CKernel::Read(unsigned long address, unsigned long sz, unsigned char data[])
{
	if(Valid && _Module.Read(this,address,sz,data))
		return S_OK;
	return E_FAIL;
}

STDMETHODIMP CKernel::Write(unsigned long address, unsigned long sz, unsigned char data[])
{
	if(Valid!=FALSE && _Module.Write(this,address,sz,data))
		return S_OK;
	return E_FAIL;
}

STDMETHODIMP CKernel::OnLogEvent(long sz, unsigned char data[])
{
	if(Valid!=FALSE && _Module.OnLogEvent(this,sz,data))
		return S_OK;
	return E_FAIL;
}
