/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: wait.h,v 1.6 2003/06/04 01:46:16 hiro Exp $
 */

/*
 *	Ԥִ⥸塼
 */

#ifndef _WAIT_H_
#define _WAIT_H_

#include "task.h"
#include "time_event.h"

/*
 *  Ԥ֤ؤΰܹ
 *
 *  ¹ΥԤ֤˰ܹԤ롥Ūˤϡ¹Υ
 *  ǥ塼TCB  winfoեɡWINFO  tmevtb
 *  ɤꤹ롥
 */
Inline void
make_wait(WINFO *winfo)
{
	make_non_runnable(runtsk);
	runtsk->winfo = winfo;
	winfo->tmevtb = NULL;
}

/*
 *  Ԥ֤ؤΰܹԡʥॢȻ
 *
 *  ¹Υ򡤥ॢȻդԤ֤˰ܹԤ롥
 *  Ūˤϡ¹Υǥ塼TCB  winfoե
 *  ɡWINFO  tmevtbեɤꤹ롥ޤ।٥ȥ
 *  åϿ롥
 */
extern void	make_wait_tmout(WINFO *winfo, TMEVTB *tmevtb, TMO tmout);

/*
 *  Ԥ
 *
 *  tcb ǻꤵ륿Ԥ֤롥Ūˤϡ।
 *  ȥ֥åϿƤСϿ롥ޤ
 *  ֤򹹿Ԥͤ E_OK Ȥ롥Ԥ塼
 *  κϹԤʤԤؤΥǥѥåɬפʾ
 *  ˤ TRUE ֤
 */
extern BOOL	wait_complete(TCB *tcb);

/*
 *  ॢȤȼԤ
 *
 *  tcb ǻꤵ륿Ԥ塼ˤĤʤƤԤ塼
 *  ֤򹹿롥ޤԤ
 *  wait_tmoutǤ E_TMOUTwait_tmout_ok Ǥ E_OK Ȥ롥Ԥ
 *  ؤΥǥѥåɬפʻϡreqflg  TRUE ˤ롥
 *  wait_tmout_ok ϡdly_tsk ǻȤΤΤǡԤ塼
 *  Ԥʤ
 *  δؿ⡤।٥ȤΥХåؿȤѤ뤿
 *  Τǡߥϥɥ餫ƤӽФ뤳ȤꤷƤ롥
 */
extern void	wait_tmout(TCB *tcb);
extern void	wait_tmout_ok(TCB *tcb);

/*
 *  Ԥ֤ζ
 *
 *  tcb ǻꤵ륿Ԥ֤Ū˲롥Ūˤϡ
 *  Ԥ塼ˤĤʤƤԤ塼।
 *  ȥ֥åϿƤФϿ롥
 *  wait_cancel ϡξ֤Ϲʤ
 *  wait_release ϡξ֤򹹿Ԥ
 *  ͤ E_RLWAI Ȥ롥ޤԤؤΥǥѥåɬ
 *  פʾˤ TRUE ֤
 */
extern void	wait_cancel(TCB *tcb);
extern BOOL	wait_release(TCB *tcb);

/*
 *  Ʊ֥̿Ȥδ֥åζʬ롼
 *
 *  Ʊ֥̿Ȥν֥åȴ֥åƬʬ϶
 *  ̤ˤʤäƤ롥ʲϡζʬ򰷤ηӥ롼
 *  Ǥ롥
 *  ʣԤ塼Ʊ֥̿Ȥξ硤ƬʳԤ
 *  塼ˤϡΥ롼ϻȤʤޤ֥
 *  ° TA_TPRI ӥåȤ򻲾ȤΤǡΥӥåȤ¾Ū˻Ȥ
 *  Ƥ⡤Υ롼ϻȤʤ
 */

/*
 *  Ʊ֥̿Ȥν֥åζʬ
 */
typedef struct wait_object_initialization_block {
	ATR	wobjatr;	/* ֥° */
} WOBJINIB;

/*
 *  Ʊ֥̿Ȥδ֥åζʬ
 */
typedef struct wait_object_control_block {
	QUEUE		wait_queue;	/* Ԥ塼 */
	const WOBJINIB	*wobjinib;	/* ֥åؤΥݥ */
} WOBJCB;

/*
 *  Ʊ֥̿Ԥ֥å
 */
typedef struct wait_object_waiting_information {
	WINFO	winfo;		/* ɸԤ֥å */
	WOBJCB	*wobjcb;	/* Ԥ֥Ȥδ֥å */
} WINFO_WOBJ;

/*
 *  Ʊ֥̿ȤФԤ֤ؤΰܹ
 *  
 *  ¹ΥԤ֤˰ܹԤƱ֥̿ȤԤ塼
 *  ˤĤʤޤԤ֥åWINFOˤ wobjcb ꤹ롥
 *  wobj_make_wait_tmout ϡ।٥ȥ֥åϿԤ
 */
extern void	wobj_make_wait(WOBJCB *wobjcb, WINFO_WOBJ *winfo);
extern void	wobj_make_wait_tmout(WOBJCB *wobjcb, WINFO_WOBJ *winfo,
					TMEVTB *tmevtb, TMO tmout);

/*
 *  ͥѹν
 *
 *  Ʊ֥̿ȤФԤ֤ˤ륿ͥ٤ѹ
 *  줿ˡԤ塼ǤΥΰ֤롥
 */
extern void	wobj_change_priority(WOBJCB *wobjcb, TCB *tcb);

#endif /* _WAIT_H_ */
