/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: component.h,v 1.8 2003/12/20 06:51:58 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/component.h,v 1.8 2003/12/20 06:51:58 takayuki Exp $

#include "base/testsuite.h"
#include "base/singleton.h"
#include "base/except.h"
#include "base/message.h"
#include "base/option.h"
#include "base/collection.h"
#include "base/directorymap.h"

#include <list>
#include <map>

#ifndef COMPONENT_H
#define COMPONENT_H

class Component : public RuntimeObject
{
public:
        //ݡͥȤεưͥ
    enum tagProcessStage {
        INITIALIZE,                 //Ȥˤư

        BEFORE_PARSE,               //ѡ
        PARSER,                     //ѡ
        AFTER_PARSE,                //ѡ

        PREDECESSOR,                //Ѥ
        GENERAL_PURPOSE,            //
        SUCCESSOR,                  //Ѥθ

        BEFORE_CODEGENERATION,      //
        CODEGENERATOR,              //
        AFTER_CODEGENERATION,       //

        FINALIZE
    };

        //ݡͥȤ˶̤Υǡ/륯饹
    class ComponentInfo
    {
    protected:
        std::string                     banner;
        std::multimap<int, Component *> componentList;
        std::list<Component *>          activatedComponentList;

            //󥹥ȥ饯 (ƥ)
        ComponentInfo(void) throw() {}
    public:
            //󥹥ȥ饯
        SINGLETON_CONSTRUCTOR(ComponentInfo) {}

            //ݡͥȤɲ
        bool addComponent(Component * component, int order) throw();

            //ݡͥȤϿ
        void removeComponent(Component * component, int order) throw();     //ͥ٤
        void removeComponent(Component * component) throw();                //Ʋ

            //ݡͥȤεư׵
        bool activateComponent(Component * component) throw();

            //ץΥѡ
        void parseOption(OptionParameter & option);

            //ݡͥȤεư
        void activateComponent(void);

            //۾ϥɥεư
        void onFatalExit(void);

            //ݡͥTưƤ뤫Ƚ
        template<class T>
        bool isActive(void) const throw()
        {
            std::list<Component *>::const_iterator scope;

            scope = activatedComponentList.begin();
            while(scope != activatedComponentList.end()) {
                if(dynamic_cast<T *>(*scope) != 0)
                    return true;
                ++ scope;
            }
            return false;
        }

            //ХʡѿؤΥ
        inline void setBanner(std::string src)
        {   banner = src;    }
        inline std::string getBanner(void) const
        {   return banner;   }


        TESTSUITE_PROTOTYPE(main)
    };


protected:
    static bool is_valid;       //ݡͥȤνɤĥե饰

    /*
     *   ȴؿ
     */

        //ݡͥȤεư
    inline bool activateComponent(void) throw()
    {   return Singleton<ComponentInfo>::getInstance()->activateComponent(this);   }

        //Ūʥץν
    static void _parseCommonOption(OptionParameter & option) throw();


        //ʬԤ륳ݡͥȤεưȽ
    template<class T>
    static bool isActive(void) throw()
    {   
        bool result = false;
        ComponentInfo * info = Singleton<ComponentInfo>::getInstance(std::nothrow);
        if(info != 0)
            result = info->isActive<T>();
        return result;
    }


        /*
         *   ȤθߴΤΥѥ᡼API
         */

    static bool findOption (const char * key1, const char * key2 = 0, std::string * = 0) throw();
    static bool checkOption(const char * key1, const char * key2 = 0) throw();
    static OptionParameter::OptionItem getOption  (const char * key1, const char * key2 = 0, bool dirty = true) throw();
    static OptionParameter::OptionItem mergeOption(const char * key1, const char * key2 = 0) throw();

public:
        //󥹥ȥ饯
    Component(int order = GENERAL_PURPOSE) throw();

        //ǥȥ饯
    virtual ~Component(void) throw();

        //ͭȽ
    static bool isValid(void) throw()
    {   return is_valid && SingletonBase::isValid();   }

        //ݡͥȤμ¹
    static void executeComponents(OptionParameter & option);
    static void executeComponents(int argc, char * argv []);

        //Хʡ
    static void        setBanner(std::string) throw(std::bad_alloc);
    static std::string getBanner(void)        throw(std::bad_alloc);

    /*
     *   ٥ȥϥɥ
     */

        //ץΥѡ
    virtual void parseOption(OptionParameter &)
    { parseOption(*Singleton<Directory>::getInstance()); }
    
    virtual void parseOption(Directory &) {}

        //ݡͥȤ
    virtual void body(void)        { body(*Singleton<Directory>::getInstance()); }
    virtual void body(Directory &) {}

        //۾ｪλϥɥ
    virtual void onFatalExit(void) {}



    TESTSUITE_PROTOTYPE(main)
};


#endif



