/*
 * stdint.h
 *
 *  Created on: 2009/07/05
 *      Author: uchan
 */

#ifndef STDINT_H_
#define STDINT_H_

typedef signed char        int8_t;
typedef unsigned char      uint8_t;
typedef signed short       int16_t;
typedef unsigned short     uint16_t;
typedef signed int         int32_t;
typedef unsigned int       uint32_t;
typedef signed long long   int64_t;
typedef unsigned long long uint64_t;

typedef int32_t  intptr_t;
typedef uint32_t uintptr_t;

typedef int64_t intmax_t;
typedef uint64_t uintmax_t;

#if (defined(__cplusplus) && defined(__STDC_LIMIT_MACROS)) \
  || !defined(__cplusplus)
#define INT8_MIN  (-0x7f)
#define INT8_MAX  (+0x7f)
#define INT16_MIN (-0x7fff)
#define INT16_MAX (+0x7fff)
#define INT32_MIN (-0x7fffffff)
#define INT32_MAX (+0x7fffffff)
#define INT64_MIN (-0x7fffffffffffffff)
#define INT64_MAX (+0x7fffffffffffffff)

#define UINT8_MAX  (+0xff)
#define UINT16_MAX (+0xffff)
#define UINT32_MAX (+0xffffffff)
#define UINT64_MAX (+0xffffffffffffffff)

#endif

#endif /* STDINT_H_ */
