package jp.sf.nikonikofw;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import jp.sf.nikonikofw.util.IOUtils;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/**
 * マルチパートリクエスト時に使用される<code>HttpServletRequest</code>のラッパークラスです。
 * 
 * @author Naoki Takezoe
 */
public class MultipartRequest extends HttpServletRequestWrapper {
	
	private Map<String, List<FileItem>> fileItems = new HashMap<String, List<FileItem>>();
	
	public MultipartRequest(HttpServletRequest request) throws IOException {
		super(request);
		
		ServletFileUpload upload = new ServletFileUpload();
		int maxSize = Config.getUploadMaxSize();
		
		try {
			FileItemIterator iterator = upload.getItemIterator(request);
			while (iterator.hasNext()) {
				FileItemStream item = iterator.next();
				
				List<FileItem> items = fileItems.get(item.getFieldName());
				if(items == null){
					items = new ArrayList<FileItem>();
					fileItems.put(item.getFieldName(), items);
				}
				
				if(item.isFormField()){
					// フォームフィールドの場合はサイズ制限なし
					items.add(new FileItem(item.getFieldName(), null, null, IOUtils.readBytes(item.openStream(), 0)));
				} else {
					// ファイルフィールドの場合はサイズ制限あり
					items.add(new FileItem(item.getFieldName(), item.getName(), item.getContentType(), 
									IOUtils.readBytes(item.openStream(), maxSize)));
				}
			}
		} catch(FileUploadException ex){
			throw new IOException(ex);
		}
	}

	@Override
	public String getParameter(String name) {
		List<FileItem> items = fileItems.get(name);
		if(items == null || items.isEmpty()){
			return null;
		}
		try {
			return new String(items.get(0).getFieldValue(), "UTF-8");
			
		} catch(UnsupportedEncodingException ex){
			return null;
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public Map getParameterMap() {
		// TODO ちゃんと実装する？
		return null;
	}

	@Override
	@SuppressWarnings("unchecked")
	public Enumeration getParameterNames() {
		// TODO ちゃんと実装する？
		return null;
	}

	@Override
	public String[] getParameterValues(String name) {
		// TODO ちゃんと実装する？
		List<FileItem> items = fileItems.get(name);
		if(items == null || items.isEmpty()){
			return new String[0];
		}
		String[] values = new String[items.size()];
		try {
			for(int i=0;i<items.size();i++){
				values[i] = new String(items.get(i).getFieldValue(), "UTF-8");
			}
		} catch(UnsupportedEncodingException ex){
			return null;
		}
		return values;
	}
	
	public FileItem getFileItem(String name){
		List<FileItem> items = fileItems.get(name);
		if(items == null || items.isEmpty()){
			return null;
		}
		return items.get(0);
	}
	
	

}
