/**********************************/
/* テーブル名: テーブル1 */
/**********************************/
CREATE TABLE MEMBER(
  ID INT NOT NULL IDENTITY,
  NAME VARCHAR(2000) NOT NULL
);

/**********************************/
/* テーブル名: テーブル2 */
/**********************************/
CREATE TABLE ENTRY(
  ID INT NOT NULL IDENTITY,
  MEMBER_ID INT NOT NULL,
  YEAR INT NOT NULL,
  MONTH INT NOT NULL,
  DAY INT NOT NULL,
  STATUS INT NOT NULL,
  MESSAGE VARCHAR(2000),
  ADD_DATE DATETIME NOT NULL,
  UPDATE_DATE DATETIME NOT NULL
);

/**********************************/
/* テーブル名: テーブル3 */
/**********************************/
CREATE TABLE GROUP_INFO(
  ID INT NOT NULL IDENTITY,
  GROUP_NAME VARCHAR(20) NOT NULL,
  DESCRIPTION VARCHAR(2000) NOT NULL
);

/**********************************/
/* テーブル名: テーブル4 */
/**********************************/
CREATE TABLE GROUP_MEMBER(
  GROUP_ID INT NOT NULL,
  MEMBER_ID INT NOT NULL
);

/**********************************/
/* テーブル名: テーブル5 */
/**********************************/
CREATE TABLE SYSTEM_INFO(
  VERSION VARCHAR(10) NOT NULL,
  INFORMATION VARCHAR(2000)
);

/**********************************/
/* テーブル名: テーブル6 */
/**********************************/
CREATE TABLE GROUP_CALENDAR(
  ID INT NOT NULL IDENTITY,
  GROUP_ID INT NOT NULL,
  YEAR INT NOT NULL,
  MONTH INT NOT NULL,
  DAY INT NOT NULL,
  DESCRIPTION VARCHAR(2000) NOT NULL
);

ALTER TABLE ENTRY ADD CONSTRAINT FK_ENTRY_0 FOREIGN KEY (MEMBER_ID) REFERENCES MEMBER (ID);

ALTER TABLE GROUP_MEMBER ADD PRIMARY KEY (GROUP_ID, MEMBER_ID);
ALTER TABLE GROUP_MEMBER ADD CONSTRAINT FK_GROUP_MEMBER_0 FOREIGN KEY (MEMBER_ID) REFERENCES MEMBER (ID);
ALTER TABLE GROUP_MEMBER ADD CONSTRAINT FK_GROUP_MEMBER_1 FOREIGN KEY (GROUP_ID) REFERENCES GROUP_INFO (ID);

ALTER TABLE GROUP_CALENDAR ADD CONSTRAINT FK_GROUP_CALENDAR_0 FOREIGN KEY (GROUP_ID) REFERENCES GROUP_INFO (ID);

INSERT INTO SYSTEM_INFO (VERSION, INFORMATION) VALUES ('1.0.0', '');
