package net.sf.amateras.nikocale.action;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import net.sf.amateras.nikocale.service.GroupService;

import org.apache.commons.lang.StringUtils;

public class SettingAction implements IAction {
	
	@Request
	public String save;
	
	@Request
	public String noAjax;
	
	@Request
	public String textarea;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		if(save != null){
			// 設定をクッキーに保存
			StringBuilder sb = new StringBuilder();
			if(StringUtils.isEmpty(noAjax)){
				sb.append("0");
				request.setAttribute("setting_noAjax", "0");
			} else {
				sb.append("1");
				request.setAttribute("setting_noAjax", "1");
			}
			if(StringUtils.isEmpty(textarea)){
				sb.append("0");
				request.setAttribute("setting_textarea", "0");
			} else {
				sb.append("1");
				request.setAttribute("setting_textarea", "1");
			}
			
			Cookie cookie = new Cookie("NIKOCALE", sb.toString());
			cookie.setMaxAge(60 * 60 * 24 * 365);
			response.addCookie(cookie);
			
			request.setAttribute("message", "設定を保存しました。");
		}
		
		request.setAttribute("title", "ユーザ設定");
		request.setAttribute("groups", GroupService.getGroups());
		
		return "setting.jsp";
	}

}
