package net.sf.amateras.nikocale.action;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.FileItem;
import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.service.MemberService;
import net.sf.amateras.nikocale.util.Utils;

public class SaveuserAction implements IAction {
	
	@Request
	@Required
	public Long memberId;
	
	@Request
	public Long groupId;
	
	@Request(label="ユーザ名")
	@Required
	public String name;
	
	@Request
	public String profile;
	
	@Request
	public String deleteImage;
	
	@Request
	public FileItem image;
	
	@Request(name="memberGroupId")
	public String[] memberGroupIds;

	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		Member member = MemberService.getMember(memberId);
		
		if(request.getParameter("delete") != null){
			MemberService.deleteMember(member);
			
			// 画像ファイルがある場合削除
			File file = new File(Utils.getImageDir(), member.getId() + ".jpg");
			if(file.exists()){
				file.delete();
			}
			
		} else {
			member.name = name;
			member.profile = profile;
			MemberService.updateMember(member);
			
			List<Long> groupIds = new ArrayList<Long>();
			if(memberGroupIds != null){
				for(String memberGroupId: memberGroupIds){
					groupIds.add(new Long(memberGroupId));
				}
			}
			MemberService.updateGroupMember(memberId, groupIds);
			
			if(deleteImage != null){
				// 画像ファイルを削除
				File file = new File(Utils.getImageDir(), member.getId() + ".jpg");
				if(file.exists()){
					file.delete();
				}
			
			} else if(image != null){
				// 画像ファイルを保存
				File dir = Utils.getImageDir();
				
				File file = new File(dir, member.getId() + ".jpg");
				if(!file.exists()){
					if(!file.createNewFile()){
						throw new IOException("画像ファイルの作成に失敗しました。");
					}
				}
				
				// リサイズ
				BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(image.getFieldValue()));
				
				int width = bufferedImage.getWidth();
				if(width > 240){
					double scale = (double) 240 / (double) width;
					
					BufferedImage dest = new BufferedImage(240, (int) (bufferedImage.getHeight() * scale),
							BufferedImage.TYPE_INT_RGB);
					
					Graphics2D g = dest.createGraphics();
					AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
					g.drawRenderedImage(bufferedImage, transform);
					
					bufferedImage = dest;
				}
				
				ImageIO.write(bufferedImage, "jpeg", new FileOutputStream(file));
			}
		}
		
		if(groupId == null){
			response.sendRedirect("member.do?memberId=" + memberId);
		} else {
			response.sendRedirect("nikocale.do?groupId=" + groupId);
		}
		return null;
	}

}
