package net.sf.amateras.nikocale.action;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.action.AbstractNikocaleAction.DateDto;
import net.sf.amateras.nikocale.annotation.Ajax;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.MemberService;

@Ajax
public class SaveAction implements IAction {

	@Request
	@Required
	public Long memberId;
	
	@Request
	@Required
	public Integer year;
	
	@Request
	@Required
	public Integer month;
	
	@Request
	@Required
	public Integer day;
	
	@Request
	@Required
	public Integer status;
	
	@Request
	public String message;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		Map<String, Entry> entries = new HashMap<String, Entry>();
		
		Entry entry = EntryService.getEntry(memberId, year, month, day);
		if(entry == null){
			entry = new Entry();
			entry.userId = memberId;
			entry.year = year;
			entry.month = month;
			entry.day = day;
			entry.status = status;
			entry.message = message.trim();
			entry.addDate = new Date();
			entry.updateDate = new Date();
			
			EntryService.saveEntry(entry);
			entries.put(memberId + "-" + day, entry);
			
		} else {
			if("delete".equals(request.getParameter("action"))){
				EntryService.deleteEntry(entry);
			} else {
				entry.status = status;
				entry.message = message.trim();
				entry.updateDate = new Date();
				
				EntryService.saveEntry(entry);
				entries.put(memberId + "-" + day, entry);
			}
		}
		
		request.setAttribute("member", MemberService.getMember(memberId));
		request.setAttribute("year", year);
		request.setAttribute("month", month);
		DateDto date = new DateDto();
		date.setDay(day);
		request.setAttribute("date", date);
		request.setAttribute("entries", entries);
		
		return "calendar.jsp";
	}

}
