package net.sf.amateras.nikocale.action;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.util.StringUtils;
import jp.sf.nikonikofw.validation.Required;
import net.arnx.jsonic.JSON;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.entity.GroupInfo;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.GroupCalendarService;
import net.sf.amateras.nikocale.service.GroupService;
import net.sf.amateras.nikocale.service.MemberService;
import net.sf.amateras.nikocale.service.SystemInfoService;

public class NikocaleAction extends AbstractNikocaleAction {

	@Request
	@Required
	public Long groupId;
	
	@Request
	public String mode;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		setDateAttributes(request);
		
		GroupInfo group = GroupService.getGroup(groupId);
		if(group == null){
			throw new DataNotFoundException("グループが存在しません。");
		}
		request.setAttribute("title", String.format("%sのニコカレ（%d年%d月）", group.groupName, year, month));
		request.setAttribute("group", group);
		
		List<Member> members = MemberService.getMembers(groupId);
		request.setAttribute("members", members);
		
		request.setAttribute("calendar", GroupCalendarService.getCalendar(groupId, year, month));
		
		Map<String, Entry> entries = EntryService.getGroupEntries(groupId, year, month);
		for(Entry entry: entries.values()){
			if(entry.getCommentCount() != 0){
				entry.setMessage(entry.getMessage() + "(" + entry.getCommentCount() + "件のコメントがあります)");
			}
		}
		request.setAttribute("entries", entries);
		
		request.setAttribute("information", SystemInfoService.getInformation());
		
		@SuppressWarnings("unchecked")
		List<DateDto> dateList = (List<DateDto>) request.getAttribute("dateList");
		DateDto lastDay = dateList.get(dateList.size() - 1);
		
		request.setAttribute("lastDay", lastDay.getDay());
		request.setAttribute("graphData", JSON.encode(EntryService.getMonthGroupGraph(
				year, month, lastDay.getDay(), members), true));
		request.setAttribute("mode", "group");
		
		if(StringUtils.isNotEmpty(mode)){
			if(mode.equals("embed")){
				request.setAttribute("embed", true);
				request.setAttribute("groupId", groupId);
				return "nikocale_embed.jsp";
			}
		}
		
		return "nikocale.jsp";
	}

}
