package net.sf.amateras.nikocale.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.GroupService;
import net.sf.amateras.nikocale.service.MemberService;
import net.sf.amateras.nikocale.util.Utils;

public class MemberAction extends AbstractNikocaleAction {

	@Request
	@Required
	public Long memberId;

	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		setDateAttributes(request);
		setCalendarAttribute(request);

		Member member = MemberService.getMember(memberId);
		if(member == null){
			throw new DataNotFoundException("ユーザが存在しません。");
		}

		request.setAttribute("title", String.format("%sさんのニコカレ（%d年%d月）", member.name, year, month));
		request.setAttribute("member", member);
		request.setAttribute("memberGroups", GroupService.getMemberGroups(memberId));
		request.setAttribute("entries", EntryService.getMemberEntries(memberId, year, month));
		request.setAttribute("count", EntryService.getMemberEntryCount(memberId));
		request.setAttribute("firstDate", EntryService.getFirstDate(memberId));
		request.setAttribute("latestDate", EntryService.getLatestDate(memberId));
		request.setAttribute("point", EntryService.getMemberPoint(memberId));
		request.setAttribute("mode", "member");
		request.setAttribute("image", Utils.existImage(memberId));

		return "member.jsp";
	}

}
