package net.sf.amateras.nikocale.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.GroupInfo;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.GroupService;

public class EditgroupAction implements IAction {

	@Request
	@Required
	public Long groupId;
	
	@Request
	public String back = "";
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		GroupInfo group = GroupService.getGroup(groupId);
		if(group == null){
			throw new DataNotFoundException("グループが存在しません。");
		}
		
		request.setAttribute("title", "グループの編集");
		request.setAttribute("group", group);
		request.setAttribute("back", back);
		
		return "editgroup.jsp";
	}

}
