<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/header.jsp" %>

${information}

<c:if test="${!empty group.description}">
  <div class="description">${group.description}</div>
</c:if>

<a href="${context}/nikocale.do?groupId=${group.id}&year=${prevYear}&month=${prevMonth}">＜前の月</a> |
<a href="${context}/nikocale.do?groupId=${group.id}">今月</a> |
<a href="${context}/nikocale.do?groupId=${group.id}&year=${nextYear}&month=${nextMonth}">次の月＞</a>
<a href="${context}/editgroup.do?groupId=${group.id}&back=nikocale"><img src="${context}/images/page_edit.png" border="0">グループ情報の編集</a>

<table class="nikocale">

<tr>
  <th>&nbsp;</th>
  <c:forEach items="${dateList}" var="date">
    <th class="${date.styleClass}"><c:out value="${date.day}"/></th>
  </c:forEach>
</tr>

<tr style="border-bottom: 4px double gray" onmouseover="this.setAttribute('class', 'highlight');" onmouseout="this.setAttribute('class', '');">
  <th class="name">グループの予定</th>
  <c:forEach items="${dateList}" var="date">
    <td align="center" class="${date.styleClass}" id="${date.day}"><%@include file="groupcal.jsp" %></td>
  </c:forEach>
</tr>

<c:forEach items="${members}" var="member">
<tr onmouseover="this.setAttribute('class', 'highlight');" onmouseout="this.setAttribute('class', '');">
  <th class="name">
    <a href="member.do?memberId=${member.id}&year=${year}&month=${month}">${f:h(member.name)}</a>
    <a href="edituser.do?memberId=${member.id}&groupId=${group.id}"><img src="images/wrench.png" border="0" title="ユーザ情報の編集"></a>
  </th>
  <c:forEach items="${dateList}" var="date">
    <td align="center" class="${date.styleClass}" id="${member.id}-${date.day}">
      <%@include file="calendar.jsp" %>
    </td>
  </c:forEach>
</tr>
</c:forEach>

</table>

<br>
<strong>${year}年${month}月のニコカレグラフ</strong>
<div id="container" style="width:600px;height:300px;"></div>

<script type="text/javascript">
document.observe('dom:loaded', function(){
	var f = Flotr.draw($('container'), ${graphData}, {
		xaxis: {
			min: 1,
			max: ${lastDay},
			tickFormatter: function(n){ return parseInt(n) + '日'; }
		}
	});
});
</script>

<br>
<form action="adduser.do" method="POST">
  このグループにメンバーを追加
  <input type="text" name="name">
  <input type="hidden" name="groupId" value="${group.id}">
  <input type="submit" name="send" value="追加">
</form>

<%@include file="/footer.jsp" %>
