<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://nikonikofw.sf.net/f" prefix="f" %>
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <script type="text/javascript" src="${context}/js/prototype.js"></script>
  <link rel="shortcut icon" href="${context}/favicon.ico" >
  <link rel="stylesheet" type="text/css" href="${context}/style.css">
  <script type="text/javascript">
  function submitForm(action){
    if(action == 'delete'){
      if(!confirm('削除します。よろしいですか？')){
        return;
      }
    }
    
    $('action').value = action;

    $('form').request({
        method: 'POST',
        onSuccess: success,
        onFailure: failure
    });
  }

  function success(response){
    <c:if test="${setting_noAjax == '1'}">
      location.href = 'nikocale.do?groupId=' + $('groupId').value;
    </c:if>
    <c:if test="${setting_noAjax != '1'}">
    var element = parent.parent.document.getElementById('${day}');
    element.innerHTML = response.responseText;
    parent.parent.GB_hide();
    </c:if>
  }

  function failure(response){
    alert(response.responseText);
  }
  </script>
  <title>${year}年${month}月${day}日の予定</title>
</head>
<body>
<div class="content">

<form action="savecal.do" method="POST" id="form" onsubmit="submitForm('save'); return false;">
  <table class="form">
  <tr>
    <th>予定</th>
    <td><textarea name="description" id="description" style="width: 450px; height: 250px;">${f:h(calendar.description)}</textarea></td>
  </tr>
  </table>
  <input type="hidden" id="groupId" name="groupId" value="${groupId}">
  <input type="hidden" name="year" value="${year}">
  <input type="hidden" name="month" value="${month}">
  <input type="hidden" name="day" value="${day}">
  <input type="hidden" name="action" id="action" value="">
  
  <input type="button" value="保存" onclick="submitForm('save');">
  <c:if test="${!empty calendar.id}">
    <input type="button" name="delete" value="この日を削除" onclick="submitForm('delete');">
  </c:if>
  <c:if test="${setting_noAjax == '1'}">
    <input type="button" value="戻る" onclick="history.back();">
  </c:if>
</form>

</div>

</body>
</html>