package jp.co.newral.workmgr.web.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.co.newral.workmgr.service.bean.UsrBean;
import jp.co.newral.workmgr.service.blogic.MgrDateChangeConfirmBLogic;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * ЈύXmFANVB
 *
 * ЈύXmFrWlXWbNĂсAЈύXmFʂ\B
 * (ύX͉ʂœ͂ꂽʏɕ\̂)
 */
public class MgrDateChangeConfirmAction extends AbstractBLogicAction<UsrBean> {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AbstractBLogicAction.class);

    /**
     * srWlXWbNNXB
     */
    private MgrDateChangeConfirmBLogic mgrDateChangeConfirmBLogic = null;

    /**
     * rWlXWbNԋpB
     *
     * @return ێrWlXWbN
     */
    public MgrDateChangeConfirmBLogic getMgrDateChangeConfirmBLogic() {
        return mgrDateChangeConfirmBLogic;
    }

    /**
     * rWlXWbNݒ肷B
     *
     * @param mgrDateChangeConfirmBLogic rWlXWbN
     */
    public void setMgrDateChangeConfirmBLogic(MgrDateChangeConfirmBLogic mgrDateChangeConfirmBLogic) {
        this.mgrDateChangeConfirmBLogic = mgrDateChangeConfirmBLogic;
    }

    /**
     * p[^̒̒lintϊł邩̔`FbN
     *
     * @return O   tOOFF  0
     *          O tOON   1
     */
    private boolean ChangeCheckInteger(String Param)  throws Exception {

        if( Param == null || Param.equals("") ) {
            // NULL or 󔒂̏ꍇ̏
            return false;
        }

        try{
//            int res = Integer.valueOf(Param);
            return true;
        }catch (NumberFormatException nfe){
            return false;
        }catch (Exception e){
            throw e;
        }
    }

    /**
     * oЁEގДNɓ͂ꂽttǂmF郁\bh
     *
     * @return Ȓl    0
     *          ُȒl   -1
     */
    private int In_OutCompanyCheck(String In_OutCompanyYhm) throws Exception{

        //---------------------------------------------------//
        // ގДN̒lint^ɕϊłꍇ̏       //
        // G[bZ[Wo͂ă^[                //
        //---------------------------------------------------//
        if( true == ChangeCheckInteger(In_OutCompanyYhm) ){

            //ގ uNvuvuv̒lint^ɕϊ
            int In_OutCompanyY = Integer.valueOf(In_OutCompanyYhm.substring(0, 4));
            int In_OutCompanyH = Integer.valueOf(In_OutCompanyYhm.substring(4, 6));
            int In_OutCompanyM = Integer.valueOf(In_OutCompanyYhm.substring(6, 8));

//            log.debug("In_OutCompanyY = [" + In_OutCompanyY + "]");
//            log.debug("In_OutCompanyH = [" + In_OutCompanyH + "]");
//            log.debug("In_OutCompanyM = [" + In_OutCompanyM + "]");

            //-----------------------------------------------------------------------//
            //ގДŃuNv 1000 ` 2100 ̊Ԃł͂Ȃꍇ  G[Ń^[ //
            //-----------------------------------------------------------------------//
            if( (1000 > In_OutCompanyY ) || (2100 < In_OutCompanyY) ) {

                return -1;
            }

            //------------------------------------------------------------------//
            //ގДŃuv 1 ` 12 ̊Ԃł͂Ȃꍇ  G[Ń^[ //
            //------------------------------------------------------------------//
            if( (0 > In_OutCompanyH ) || (12 < In_OutCompanyH) ) {

                return -1;
            }

            //------------------------------------------------------------------//
            //ގДŃuv 1 ` 31 ̊Ԃł͂Ȃꍇ  G[Ń^[ //
            //------------------------------------------------------------------//
            if( (0 > In_OutCompanyM ) || (31 < In_OutCompanyM) ) {

                return -1;


            //------------------------------------------------------------------------------------//
            //ގДŃuv 1 ` 31 ̊Ԃłeɑ݂Ȃt̏ꍇ  G[Ń^[ //
            //(F431 )                                                                    //
            //------------------------------------------------------------------------------------//
            }else{

                switch(In_OutCompanyH){
                //2  ő29܂ł݂Ȃ
                case 2:
                    if(In_OutCompanyM > 29){
                        return -1;
                    }

                //4  30܂ł݂Ȃ
                case 4:
                    if(In_OutCompanyM > 30){
                        return -1;
                    }

                //6  30܂ł݂Ȃ
                case 6:
                    if(In_OutCompanyM > 30){
                        return -1;
                    }

                //9  30܂ł݂Ȃ
                case 9:
                    if(In_OutCompanyM > 30){
                        return -1;
                    }

                //11  30܂ł݂Ȃ
                case 11:
                    if(In_OutCompanyM > 30){
                        return -1;
                    }
                }
            }

        //---------------------------------------------------//
        // ގДN̒lint^ɕϊłȂꍇ̏ //
        // G[bZ[Wo͂ă^[                //
        //---------------------------------------------------//
        }else{

            return -1;

         }

        //܂ŏƂƂ͕ϐ[OutCompanyYhm]ɐȓt͂ꂽƂ
        return 0;

    }



    /**
     * [AhXDBo^pɕҏW
     * ( [AhX    "@newral.co.jp" ǉ)
     * ( [AhX  ""              )
     *
     * @param   mailAddressPram : ύXʂœ͂ꂽ[AhX
     * @return  mailAddress     : "@newral.co.jp" ǋL[AhX or ""
     */
    public String mailAddressFormat(String mailAddressPram) {

        String mailAddress;
        int length     = mailAddressPram.length();

        //----------------------------------------------//
        // ύXʂŃ[AhX͂Ăꍇ //
        //----------------------------------------------//
        if(length > 1) {
            //͂ꂽύX[AhX "@newral.co.jp" ǉ
            mailAddress = mailAddressPram + "@newral.co.jp";

        //------------------------------------------------//
        // ύXʂŃ[AhX͂ĂȂꍇ //
        //------------------------------------------------//
        }else{
            // ftHg
            mailAddress = "";
        }
        return mailAddress;
    }


    /**
     * rWlXWbNsAЈo^擾AԋpB
     *
     * @param usrBean Јo^擾̂߂̕ϐێUsrBean
     * @return Јo^ێBLogicResult
     * @throws Exception O
     */
    @Override
    public BLogicResult doExecuteBLogic(UsrBean usrBean)
        throws Exception {

        log.debug("MgrDateChangeConfirmAction IN");

        //BLogicResult̐Aʂ̐ݒ
        BLogicResult result = new BLogicResult();

        //oЁEގДN̒l[Jϐɑ
        String InCompanyYhm  = usrBean.getChangeInCompanyYhm();
        String OutCompanyYhm = usrBean.getChangeOutCompanyYhm();

        //===================================================================//
        // oДN[InCompanyYhm] ̒lȒl𒲂ׂG[菈   //
        // Ȓl(F20091026)  ̂܂܏𑱂                    //
        // ُȒl(F20091033)  G[bZ[Wo͂ă^[  //
        //===================================================================//
        int InCompanyCheck = In_OutCompanyCheck(InCompanyYhm);
        //-------------------------//
        //ُȒlꍇ̏ //
        //-------------------------//
        if(InCompanyCheck < 0){

            //BLogicResult̐Aʂ̐ݒ
            result.setResultString("InCompany_error");

            //G[bZ[W̍쐬
            BLogicMessages errors = new BLogicMessages();
            errors.add("InCompany", new BLogicMessage("error.InCompanyYhm"));
            result.setErrors(errors);
            result.setResultObject(usrBean);
            return result;
        }

        //===================================================================//
        // ގДN[OutCompanyYhm] ̒lȒl𒲂ׂG[菈  //
        // Ȓl(F20091026)  ̂܂܏𑱂                    //
        // ُȒl(F20091033)  G[bZ[Wo͂ă^[  //
        //===================================================================//
        int OutCompanyCheck = In_OutCompanyCheck(OutCompanyYhm);
        //------------------------------------------------------------------//
        //ُȒlꍇ̏ (ގДN̂݋󔒂́u폈vɂȂ) //
        //------------------------------------------------------------------//
        if( (OutCompanyCheck < 0) && (OutCompanyYhm.length() == 8) ){

            //BLogicResult̐Aʂ̐ݒ
            result.setResultString("OutCompany_error");

            //G[bZ[W̍쐬
            BLogicMessages errors = new BLogicMessages();
            errors.add("OutCompany", new BLogicMessage("error.OutCompanyYhm"));
            result.setErrors(errors);
            result.setResultObject(usrBean);
            return result;
        }


        // 牺Ő펞̏̊Jn //

        //-------------------------------------------------------//
        // ގДNi[ϐ[OutCompanyYhm]̒l󔒂ꍇ //
        // 폈  "-"                                 //
        //-------------------------------------------------------//
        if(OutCompanyYhm.length() != 8){
            usrBean.setChangeOutCompanyYhm("-");
        }

        //͂ꂽύX[AhX "@newral.co.jp" ǉ
        usrBean.setChangeMailAddress(mailAddressFormat(usrBean.getChangeMailAddress()));

        //ύX\IDԍ(selectId)staffId֑
        usrBean.setStaffId(usrBean.getSelectId());

        //rWlXWbN̎sAʂ̎擾
        UsrVO uvo = usrBean.getUvo();
        UsrBean usrBeanBuf = usrBean;

        result.setResultString("success");
        result.setResultObject(usrBeanBuf);
        BLogicMessages messages = new BLogicMessages();
        messages.add("mgr.message",
                new BLogicMessage("mgr.message", uvo.getStaffName()));
        result.setMessages(messages);


        log.debug("MgrDateChangeConfirmAction OUT");

        return result;
    }

}
