
package jp.co.newral.workmgr.service.blogic;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.DownloadFile;
import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.co.newral.workmgr.service.bean.*;

import jp.ne.so_net.ga2.no_ji.jcom.excel8.*;
import jp.ne.so_net.ga2.no_ji.jcom.*;

import java.lang.Integer;
import java.lang.Long;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.channels.FileChannel;

/**
 * ꗗ擾rWlXWbNB
 *
 * f[^x[Xʂɕ\錏݈̂ꗗ擾B
 * ܂Aꗗ̑S擾B
 *
 */
public class UsrTimeListDownloadBLogicImpl implements UsrTimeListDownloadBLogic{

    /**
     * DAONXB
     */
    private QueryDAO dao = null;

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getDao() {
        return dao;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param dao QueryDAO
     */
    public void setDao(QueryDAO dao) {
        this.dao = dao;
    }

    /**
     * NǍ̓߂B
     *
     * @param dao QueryDAO
     */
    private int num_of_day(int year, int month)
    {
        int num_days[] = {31,28,31,30,31,30,31,31,30,31,30,31};

        if((month==2) && (((year%400)==0) || (((year%100)!=0) && ((year%4)==0)))){
            return 29;
        }else{
            return num_days[month-1];
        }
    }


    /********************************
     *                              *
     *  Jcomgďo͂s      *
     *                              *
     ********************************/
    public BLogicResult jcomExecute(UsrBean usrBean) {

        String thisyear = null;
        String thismonth = null;

        //Calendar擾
//        Calendar date = Calendar.getInstance();

        //͂ꂽ[UID̎擾Ai[
        UsrVO uvo;
        uvo = usrBean.getUvo();
        UsrBean usrBeanBuf = new UsrBean();
        usrBeanBuf.setStaffId(uvo.getStaffId());


        /************************************************
         *      f[^x[Ẍׂ̔N߂      *
         ************************************************/
        //ݕ\Ă\̔Nsession瓾B
        String selectYm = usrBean.getSelectListYmd();

        //ĂlNƌɐ؂蕪
        int monthVal = Integer.valueOf(selectYm.substring(4));
        int yearVal = Integer.valueOf(selectYm.substring(0,4));

        //ύXꂽNAstringϐɓȂ
        thisyear = Integer.toString(yearVal);
        thismonth = String.format("%1$02d",monthVal);


        /************************************
         *     f[^x[XANZX     *
         ************************************/
        //DBp̔Ni[B
        usrBeanBuf.settimeListSelectYM('%'+ thisyear + thismonth +'%');
        //DBANZX
        UsrBean[] bean = dao.executeForObjectArray("selectTimeList", usrBeanBuf,UsrBean.class);


        /********************************
         *  Ζ\t@CRs[  *
         ********************************/
        //EXCELp̃IuWFNg擾
        ReleaseManager rm = new ReleaseManager();

        //tH[}bgɊÂAo͂Ζ\̖O쐬B
        String outputFileName = "Ζ\"+ thisyear.substring(2) + thismonth + String.format("%1$03d",usrBeanBuf.getStaffId()) + ".xls";
        //o͂Ζ\̃tpX쐬
        //String outputFileNamePath = "C:\\Program Files\\Apache Software Foundation\\Tomcat 5.5\\webapps\\webapps\\workmgr\\Ζ\\\"+outputFileName;
        String outputFileNamePath = "C:\\Documents and Settings\\Administrator\\Ζ\\\"+outputFileName;

        //Ζ\blankRs[Ao͂Ζ\̖OŐVΖ\t@C쐬B
        try{
            //Rs[t@C̃pXw
            FileChannel sourceChannel = new FileInputStream("C:\\Documents and Settings\\Administrator\\Ζ\\\Ζ\blank.xls").getChannel();
            //Rs[t@C̃pXw
            FileChannel destinationChannel = new FileOutputStream(outputFileNamePath).getChannel();
            //Rs[pXRs[pXփoCg]
            sourceChannel.transferTo(0, sourceChannel.size(), destinationChannel);
            sourceChannel.close();
            destinationChannel.close();

        /****************************************
         *            excelݏ             *
         ****************************************/

            //EXCELAvP[VN
            // EXCELłɗオĂƁAVEBhEŊJB
            ExcelApplication excel = new ExcelApplication(rm);
            excel.Visible(true);

            //Ζ\t@CAvP[VJ
            ExcelWorkbooks xlBooks = excel.Workbooks();
            ExcelWorkbook xlBook = xlBooks.Open(outputFileNamePath);

            //Ζ\t@C1Ԗڂ̃[NV[gɏނ悤w
            ExcelWorksheets xlSheets = xlBook.Worksheets();
            ExcelWorksheet xlSheet = xlSheets.Item(1);
            ExcelRange xlRange = xlSheet.Cells();

            //***********݊Jn**********//
            //NAAID
            xlRange.Item(2,5).Value((new Long(thismonth)));
            xlRange.Item(2,2).Value((new Long(thisyear)));
            xlRange.Item(3,21).Value((new Long(usrBeanBuf.getStaffId())));

            //N猎̓߂B
            int row = num_of_day(Integer.valueOf(thisyear), Integer.valueOf(thismonth));    //\̍ڐ

            int daycount = 0;        //JE^[
            int datacount = 0;        //beañf[^JE^[
            String bufcheck ="";    //OutHm󔒂ǂ𒲂ׂׂ̕ϐ

            //dayCount[vB
            for(daycount=0 ; daycount<row ; daycount++){
                //f[^p̔N쐬
                String sarchlistymd = String.format("%1$s%2$s%3$02d",thisyear,thismonth,daycount+1);

                //beañf[^JE^[őɂȂĂ
                //DBĂf[^͑SdownLoadChartɊi[IĂ̂ŁAcׂ͂ăf[^B
                if(datacount >= bean.length){
                    break;
                }
                //f[^p̔NDBĂNvĂ
                //xlRange.Itemɒli[AdatacountCNgBiDBf[^j
                else if(sarchlistymd.equals(bean[datacount].getInoutYmd()) == true){
                    String inHmStr = bean[datacount].getInHm();

                    //Ўi[
                    xlRange.Item(daycount+8,7).Value(Integer.valueOf(inHmStr.substring(0,2)));
                    //Еi[
                    xlRange.Item(daycount+8,8).Value(Integer.valueOf(inHmStr.substring(2,4)));

                    //ގЎԂDBɓo^Ă鎞iގЏĂȂj
                    //lxlRange.ItemɊi[
                    if((bean[datacount].getOutHm() == null || bufcheck.equals(bean[datacount].getOutHm())) != true){
                        String OutHmStr = bean[datacount].getOutHm();

                        //ގЎi[
                        xlRange.Item(daycount+8,9).Value(Integer.valueOf(OutHmStr.substring(0,2)));
                        //ގЕi[
                        xlRange.Item(daycount+8,10).Value(Integer.valueOf(OutHmStr.substring(2,4)));
                    }
                    datacount++;
                }
            }

            //t@C̏㏑ۑ
            xlBook.Save();
            //t@C
            xlBook.Close(false,null,false);
            //EXCELAvP[VI
            excel.Quit();
        }
        catch(Exception e) {
            //G[AbZ[W쐬ĕԋpE
            BLogicResult result = new BLogicResult();
            result.setResultString("excelError");
            BLogicMessages errors = new BLogicMessages();
            errors.add("telStaffId", new BLogicMessage("errors.excelErrors"));
            result.setErrors(errors);
            result.setResultObject(usrBean);
            return result;
        }
        finally {
            //EXCELp̃IuWFNgJ
            rm.release();
        }
        /***************************************/

        /****************************************
         *            _E[h        *
         ****************************************/
        BLogicResult result = new BLogicResult();
        File file = new File(outputFileNamePath);

        DownloadFile downloadFile = new DownloadFile(file);
        result.setResultObject(downloadFile);
        result.setResultString("success");
        return result;
    }
}
