/*
* Copyright (c) 2007 NTT DATA Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package jp.co.newral.workmgr.common.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * oގЊǗVXe<br>
 * NGXgp[^̃GR[fBOstB^[NX
 *
 * @version 1.0 2009/08/01 VK쐬
 * @version 1.1 2009/11/01 RgC
 * @author newral
 */
public class WmSetCharacterEncodingFilter implements Filter {

    /** Oo */
    private Log log = LogFactory.getLog(WmSetCharacterEncodingFilter.class);

    /** GR[fBO */
    protected String encoding = null;

    /** tB^[RtBO */
    protected FilterConfig filterConfig = null;

    /** NCAgŎw肳ꂽGR[fBO𖳎邩ǂ̃tO */
    protected boolean ignore = true;

    /**
     * sB<br>
     *
     * @param filterConfig tB^[ݒ
     * @exception ServletException T[ubgO
     */
     public void init(FilterConfig filterConfig) throws ServletException {
         if (log.isDebugEnabled()) { log.debug("IN"); }

         // ̃tB^[ݒCX^Xϐɐݒ肷B
         this.filterConfig = filterConfig;

         // tB^[ݒ肩GR[fBO擾B
         encoding = filterConfig.getInitParameter("encoding");
         if (log.isDebugEnabled()) { log.debug("encoding=[" + encoding + "]"); }

         // GR[fBOݒ薳tO̒l擾B
         String value = filterConfig.getInitParameter("ignore");

         // GR[fBOݒ薳tO̒l擾łȂꍇ
         if (value == null) {
             // GR[fBOݒ薳tO𖳌(true)ɐݒ肷B
             ignore = true;

         // 擾GR[fBOݒ薳tO̒l"true"̏ꍇ
         } else if (value.equalsIgnoreCase("true")) {
             // GR[fBOݒ薳tO𖳌(true)ɐݒ肷B
             ignore = true;

         // 擾GR[fBOݒ薳tO̒l"yes"̏ꍇ
         } else if (value.equalsIgnoreCase("yes")) {
             // GR[fBOݒ薳tO𖳌(true)ɐݒ肷B
             ignore = true;

         // LȊO
         } else {
             // GR[fBOݒ薳tOL(false)ɐݒ肷B
             ignore = false;
         }

         if (log.isDebugEnabled()) { log.debug("ignore=[" + ignore + "]"); }
         if (log.isDebugEnabled()) { log.debug("OUT(OK)"); }
     }

    /**
     * ȈsB<br>
     * CX^XϐNAB
     */
    public void destroy() {
        encoding = null;
        filterConfig = null;
        ignore = true;
    }

    /**
    * tB^[sB<br>
    * NGXgp[^w肳ꂽGR[fBOɐݒ肷B
    *
    * @param request T[ubgNGXg
    * @param response T[ubgX|X
    * @param chain tB^[`F[
    * @exception IOException IOO
    * @exception ServletException T[ubgO
    */
    public void doFilter(
            ServletRequest request,
            ServletResponse response,
            FilterChain chain)
                throws
                    IOException,
                    ServletException {
        if (log.isDebugEnabled()) { log.debug("IN"); }

        // GR[fBOݒ肷܂̓NGXg̕GR[fBOw肪
        // ݒ肳ĂȂꍇ
        if (ignore || (request.getCharacterEncoding() == null)) {
            // GR[fBO擾B
            String encoding = selectEncoding(request);
            // GR[fBO擾łꍇ
            if (encoding != null) {
                // NGXgɐݒ肷B
                request.setCharacterEncoding(encoding);
            }
        }
        chain.doFilter(request, response);

        if (log.isDebugEnabled()) { log.debug("OUT(OK)"); }
    }

    /**
    * GR[fBOIB
    *
    * @param request NGXg
    * @return GR[fBO
    */
    protected String selectEncoding(ServletRequest request) {
        return encoding;
    }
}
