package jp.co.newral.workmgr.common.filter;

import java.util.List;
import java.util.ArrayList;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.newral.workmgr.common.bean.UsrVO;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AuthorizationController;

/**
 * oގЊǗVXe<br>
 * ANZX`FbNsRg[NX
 *
 * @version 1.0 2009/08/01 VK쐬
 * @version 1.1 2009/11/01 RgC
 * @author newral
 */
public class WmAuthorizationController implements AuthorizationController {

    /** Oo */
    private Log log = LogFactory.getLog(WmAuthorizationController.class);

    /** [UIuWFNg擾L[ */
    private static final String USER_VALUE_OBJECT_KEY = "USER_VALUE_OBJECT";

    /** `FbNΏۊOpX擾L[ړ */
    private static final String NOCHECK_PATH_PREFIX = "authorization.escape.";

    /** `FbNΏۊOpXXg */
    private List<String> noCheckList = null;

    /**
     * pXOCς݃`FbNΏۂ肷B
     *
     * @param  request T[ubgNGXg
     * @return 茋<br>
     * true:`FbNΏ<br>
     * false:`FbNΏۊO
     */
    public boolean isCheckRequired(ServletRequest request) {
        if (log.isDebugEnabled()) { log.debug("IN"); }

        // pX擾B
        String pathInfo = RequestUtil.getPathInfo(request);
        if (log.isDebugEnabled()) { log.debug("PathInfo=[" + pathInfo + "]"); }

        // pX񂪎擾łȂꍇ
        if ((null == pathInfo) || "".equals(pathInfo)) {
            // OX[B
            throw new RuntimeException("pX񂪎擾ł܂B");
        }

        // `FbNΏۊOXgݒ肷B
        setNoCheckList();

        // `FbNΏۊOpXXg̐ݒ萔JԂB
        for (String path : noCheckList) {
            // `FbNΏۊOpX܂̓ReLXg[g("/")̏ꍇ
            if (pathInfo.startsWith(path) || "/".equals(pathInfo)) {
                // `FbNΏۊO(false)ԋpB
                if (log.isDebugEnabled()) { log.debug("result=[false]"); }
                if (log.isDebugEnabled()) { log.debug("OUT(OK)"); }
                return false;
            }
        }

        // `FbNΏ(true)ԋpB
        if (log.isDebugEnabled()) { log.debug("result=[true]"); }
        if (log.isDebugEnabled()) { log.debug("OUT(OK)"); }
        return true;
    }

    /**
    * NGXg̃pXɑ΂āA
    * w肳ꂽHTTPZbVF؍ς݂ł邩ǂ𔻒肷B
    *
    * @param   pathInfo   pX
    * @param   req        HTTPNGXg
    *
    * @return  F؂ɐ true  (ANZXȂ)
    *           F؂Ɏs false (ANZX)
    */
    public boolean isAuthorized(String pathInfo, ServletRequest request) {
        if (log.isDebugEnabled()) { log.debug("IN"); }

        // ZbV擾B
        HttpSession session = ((HttpServletRequest)request).getSession();

        // ZbVUVO擾B
        UsrVO uvo = (UsrVO)session.getAttribute(USER_VALUE_OBJECT_KEY);

        // UVO擾łA[UIDݒ肳Ăꍇ
        if ((null != uvo) && (null != uvo.getStaffId())) {
            // OCς(true)ԋpB
            if (log.isDebugEnabled()) { log.debug("result=[true]"); }
            if (log.isDebugEnabled()) { log.debug("OUT(OK)"); }
            return true;
        }

        // OC(false)ԋpB
        if (log.isDebugEnabled()) { log.debug("result=[false]"); }
        if (log.isDebugEnabled()) { log.debug("OUT(NG)"); }
        return false;
    }

    /**
     * `FbNΏۊOXgݒ肷B
     */
    private void setNoCheckList() {
        if (log.isDebugEnabled()) { log.debug("IN"); }

        // `FbNΏۊOXgݒ肳ĂȂꍇ
        if (null == noCheckList) {
            // `FbNΏۊOXg𐶐B
            noCheckList = new ArrayList<String>();

            // vpeB`FbNΏۊOpX擾łȂȂ܂ŌJԂB
            for (int i = 1; ; i++) {
                // `FbNΏۊOpXvpeB(system.properties)擾B
                String path = PropertyUtil.getProperty(NOCHECK_PATH_PREFIX + i);
                if (log.isDebugEnabled()) { log.debug("Path[" + i + "]=["+ path + "]"); }

                // `FbNΏۊOpX擾łȂꍇ
                if (null == path) {
                    // [vIB
                    break;
                }

                // 擾`FbNΏۊOpX`FbNΏۊOpXXg֒ǉB
                noCheckList.add(path);
            }
        }

        if (log.isDebugEnabled()) { log.debug("OUT(OK)"); }
    }
}
