/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BooleanExpression;
import org.activemq.filter.mockrunner.Expression;
import org.activemq.filter.mockrunner.PropertyExpression;

public abstract class UnaryExpression
implements Expression {
    private static final BigDecimal BD_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    protected Expression right;

    public static Expression createNegate(Expression expression) {
        return new UnaryExpression(expression){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Object object = this.right.evaluate(message);
                if (object == null) {
                    return null;
                }
                if (object instanceof Number) {
                    return UnaryExpression.negate((Number)object);
                }
                return null;
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static BooleanExpression createInExpression(PropertyExpression propertyExpression, List list, final boolean bl) {
        Collection collection = list.size() == 0 ? null : (list.size() < 5 ? list : new HashSet(list));
        final List list2 = collection;
        return new BooleanUnaryExpression(propertyExpression){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Object object = this.right.evaluate(message);
                if (object == null) {
                    return null;
                }
                if (object.getClass() != String.class) {
                    return null;
                }
                if ((list2 != null && list2.contains(object)) ^ bl) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.right);
                stringBuffer.append(" ");
                stringBuffer.append(this.getExpressionSymbol());
                stringBuffer.append(" ( ");
                int n = 0;
                for (Object e : list2) {
                    if (n != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(e);
                    ++n;
                }
                stringBuffer.append(" )");
                return stringBuffer.toString();
            }

            @Override
            public String getExpressionSymbol() {
                if (bl) {
                    return "NOT IN";
                }
                return "IN";
            }
        };
    }

    public static BooleanExpression createNOT(BooleanExpression booleanExpression) {
        return new BooleanUnaryExpression(booleanExpression){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Boolean bl = (Boolean)this.right.evaluate(message);
                if (bl == null) {
                    return null;
                }
                return bl != false ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    public static BooleanExpression createBooleanCast(Expression expression) {
        return new BooleanUnaryExpression(expression){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Object object = this.right.evaluate(message);
                if (object == null) {
                    return null;
                }
                if (!object.getClass().equals(Boolean.class)) {
                    return Boolean.FALSE;
                }
                return object;
            }

            @Override
            public String getExpressionSymbol() {
                return "NOT";
            }
        };
    }

    private static Number negate(Number number) {
        Class<?> clazz = number.getClass();
        if (clazz == Integer.class) {
            return new Integer(-number.intValue());
        }
        if (clazz == Long.class) {
            return new Long(-number.longValue());
        }
        if (clazz == Float.class) {
            return new Float(-number.floatValue());
        }
        if (clazz == Double.class) {
            return new Double(-number.doubleValue());
        }
        if (clazz == BigDecimal.class) {
            BigDecimal bigDecimal = (BigDecimal)number;
            if (BD_LONG_MIN_VALUE.compareTo(bigDecimal = bigDecimal.negate()) == 0) {
                return new Long(Long.MIN_VALUE);
            }
            return bigDecimal;
        }
        throw new RuntimeException("Don't know how to negate: " + number);
    }

    public UnaryExpression(Expression expression) {
        this.right = expression;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression expression) {
        this.right = expression;
    }

    public String toString() {
        return "(" + this.getExpressionSymbol() + " " + this.right.toString() + ")";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public abstract String getExpressionSymbol();

    static abstract class BooleanUnaryExpression
    extends UnaryExpression
    implements BooleanExpression {
        public BooleanUnaryExpression(Expression expression) {
            super(expression);
        }
    }
}

