/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter.mockrunner;

import java.util.HashSet;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import org.activemq.filter.mockrunner.BinaryExpression;
import org.activemq.filter.mockrunner.BooleanExpression;
import org.activemq.filter.mockrunner.ConstantExpression;
import org.activemq.filter.mockrunner.Expression;
import org.activemq.filter.mockrunner.LogicExpression;
import org.activemq.filter.mockrunner.PropertyExpression;
import org.activemq.filter.mockrunner.UnaryExpression;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class ComparisonExpression
extends BinaryExpression
implements BooleanExpression {
    private static final HashSet REGEXP_CONTROL_CHARS = new HashSet();

    public static BooleanExpression createBetween(Expression expression, Expression expression2, Expression expression3) {
        return LogicExpression.createAND(ComparisonExpression.createGreaterThanEqual(expression, expression2), ComparisonExpression.createLessThanEqual(expression, expression3));
    }

    public static BooleanExpression createNotBetween(Expression expression, Expression expression2, Expression expression3) {
        return LogicExpression.createOR(ComparisonExpression.createLessThan(expression, expression2), ComparisonExpression.createGreaterThan(expression, expression3));
    }

    public static BooleanExpression createLike(Expression expression, String string, String string2) {
        if (string2 != null && string2.length() != 1) {
            throw new RuntimeException("The ESCAPE string litteral is invalid.  It can only be one character.  Litteral used: " + string2);
        }
        int n = -1;
        if (string2 != null) {
            n = 0xFFFF & string2.charAt(0);
        }
        return new LikeExpression(expression, string, n);
    }

    public static BooleanExpression createNotLike(Expression expression, String string, String string2) {
        return UnaryExpression.createNOT(ComparisonExpression.createLike(expression, string, string2));
    }

    public static BooleanExpression createInFilter(Expression expression, List list) {
        if (!(expression instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + expression);
        }
        return UnaryExpression.createInExpression((PropertyExpression)expression, list, false);
    }

    public static BooleanExpression createNotInFilter(Expression expression, List list) {
        if (!(expression instanceof PropertyExpression)) {
            throw new RuntimeException("Expected a property for In expression, got: " + expression);
        }
        return UnaryExpression.createInExpression((PropertyExpression)expression, list, true);
    }

    public static BooleanExpression createIsNull(Expression expression) {
        return ComparisonExpression.doCreateEqual(expression, ConstantExpression.NULL);
    }

    public static BooleanExpression createIsNotNull(Expression expression) {
        return UnaryExpression.createNOT(ComparisonExpression.doCreateEqual(expression, ConstantExpression.NULL));
    }

    public static BooleanExpression createNotEqual(Expression expression, Expression expression2) {
        return UnaryExpression.createNOT(ComparisonExpression.createEqual(expression, expression2));
    }

    public static BooleanExpression createEqual(Expression expression, Expression expression2) {
        ComparisonExpression.checkEqualOperand(expression);
        ComparisonExpression.checkEqualOperand(expression2);
        ComparisonExpression.checkEqualOperandCompatability(expression, expression2);
        return ComparisonExpression.doCreateEqual(expression, expression2);
    }

    private static BooleanExpression doCreateEqual(Expression expression, Expression expression2) {
        return new ComparisonExpression(expression, expression2){

            @Override
            public Object evaluate(Message message) throws JMSException {
                Comparable comparable;
                Object object;
                Object object2 = this.left.evaluate(message);
                if (object2 == null ^ (object = this.right.evaluate(message)) == null) {
                    return Boolean.FALSE;
                }
                if (object2 == object || object2.equals(object)) {
                    return Boolean.TRUE;
                }
                Comparable comparable2 = object2 instanceof Comparable ? (Comparable)object2 : null;
                Comparable comparable3 = comparable = object instanceof Comparable ? (Comparable)object : null;
                if (comparable2 == null || comparable == null) {
                    return Boolean.FALSE;
                }
                return this.compare(comparable2, comparable);
            }

            @Override
            protected boolean asBoolean(int n) {
                return n == 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "=";
            }
        };
    }

    public static BooleanExpression createGreaterThan(Expression expression, Expression expression2) {
        ComparisonExpression.checkLessThanOperand(expression);
        ComparisonExpression.checkLessThanOperand(expression2);
        return new ComparisonExpression(expression, expression2){

            @Override
            protected boolean asBoolean(int n) {
                return n > 0;
            }

            @Override
            public String getExpressionSymbol() {
                return ">";
            }
        };
    }

    public static BooleanExpression createGreaterThanEqual(Expression expression, Expression expression2) {
        ComparisonExpression.checkLessThanOperand(expression);
        ComparisonExpression.checkLessThanOperand(expression2);
        return new ComparisonExpression(expression, expression2){

            @Override
            protected boolean asBoolean(int n) {
                return n >= 0;
            }

            @Override
            public String getExpressionSymbol() {
                return ">=";
            }
        };
    }

    public static BooleanExpression createLessThan(Expression expression, Expression expression2) {
        ComparisonExpression.checkLessThanOperand(expression);
        ComparisonExpression.checkLessThanOperand(expression2);
        return new ComparisonExpression(expression, expression2){

            @Override
            protected boolean asBoolean(int n) {
                return n < 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "<";
            }
        };
    }

    public static BooleanExpression createLessThanEqual(Expression expression, Expression expression2) {
        ComparisonExpression.checkLessThanOperand(expression);
        ComparisonExpression.checkLessThanOperand(expression2);
        return new ComparisonExpression(expression, expression2){

            @Override
            protected boolean asBoolean(int n) {
                return n <= 0;
            }

            @Override
            public String getExpressionSymbol() {
                return "<=";
            }
        };
    }

    public static void checkLessThanOperand(Expression expression) {
        if (expression instanceof ConstantExpression) {
            Object object = ((ConstantExpression)expression).getValue();
            if (object instanceof Number) {
                return;
            }
            throw new RuntimeException("Value '" + expression + "' cannot be compared.");
        }
        if (expression instanceof BooleanExpression) {
            throw new RuntimeException("Value '" + expression + "' cannot be compared.");
        }
    }

    public static void checkEqualOperand(Expression expression) {
        Object object;
        if (expression instanceof ConstantExpression && (object = ((ConstantExpression)expression).getValue()) == null) {
            throw new RuntimeException("'" + expression + "' cannot be compared.");
        }
    }

    private static void checkEqualOperandCompatability(Expression expression, Expression expression2) {
        if (expression instanceof ConstantExpression && expression2 instanceof ConstantExpression && expression instanceof BooleanExpression && !(expression2 instanceof BooleanExpression)) {
            throw new RuntimeException("'" + expression + "' cannot be compared with '" + expression2 + "'");
        }
    }

    public ComparisonExpression(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        Comparable comparable = (Comparable)this.left.evaluate(message);
        if (comparable == null) {
            return null;
        }
        Comparable comparable2 = (Comparable)this.right.evaluate(message);
        if (comparable2 == null) {
            return null;
        }
        return this.compare(comparable, comparable2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Boolean compare(Comparable comparable, Comparable comparable2) {
        Class<?> clazz;
        Class<?> clazz2 = comparable.getClass();
        if (clazz2 == (clazz = comparable2.getClass())) return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
        if (clazz2 == Integer.class) {
            if (clazz == Long.class) {
                comparable = new Long(((Number)((Object)comparable)).longValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (clazz == Float.class) {
                comparable = new Float(((Number)((Object)comparable)).floatValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (clazz != Double.class) return Boolean.FALSE;
                comparable = new Double(((Number)((Object)comparable)).doubleValue());
            }
            return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (clazz2 == Long.class) {
            if (clazz == Integer.class) {
                comparable2 = new Long(((Number)((Object)comparable2)).longValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (clazz == Float.class) {
                comparable = new Float(((Number)((Object)comparable)).floatValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (clazz != Double.class) return Boolean.FALSE;
                comparable = new Double(((Number)((Object)comparable)).doubleValue());
            }
            return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
        } else if (clazz2 == Float.class) {
            if (clazz == Integer.class) {
                comparable2 = new Float(((Number)((Object)comparable2)).floatValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (clazz == Long.class) {
                comparable2 = new Float(((Number)((Object)comparable2)).floatValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (clazz != Double.class) return Boolean.FALSE;
                comparable = new Double(((Number)((Object)comparable)).doubleValue());
            }
            return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
        } else {
            if (clazz2 != Double.class) return Boolean.FALSE;
            if (clazz == Integer.class) {
                comparable2 = new Double(((Number)((Object)comparable2)).doubleValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else if (clazz == Long.class) {
                comparable2 = new Double(((Number)((Object)comparable2)).doubleValue());
                return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (clazz != Float.class) return Boolean.FALSE;
                comparable2 = new Float(((Number)((Object)comparable2)).doubleValue());
            }
        }
        return this.asBoolean(comparable.compareTo(comparable2)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected abstract boolean asBoolean(int var1);

    static {
        REGEXP_CONTROL_CHARS.add(new Character('.'));
        REGEXP_CONTROL_CHARS.add(new Character('\\'));
        REGEXP_CONTROL_CHARS.add(new Character('['));
        REGEXP_CONTROL_CHARS.add(new Character(']'));
        REGEXP_CONTROL_CHARS.add(new Character('^'));
        REGEXP_CONTROL_CHARS.add(new Character('$'));
        REGEXP_CONTROL_CHARS.add(new Character('?'));
        REGEXP_CONTROL_CHARS.add(new Character('*'));
        REGEXP_CONTROL_CHARS.add(new Character('+'));
        REGEXP_CONTROL_CHARS.add(new Character('{'));
        REGEXP_CONTROL_CHARS.add(new Character('}'));
        REGEXP_CONTROL_CHARS.add(new Character('|'));
        REGEXP_CONTROL_CHARS.add(new Character('('));
        REGEXP_CONTROL_CHARS.add(new Character(')'));
        REGEXP_CONTROL_CHARS.add(new Character(':'));
        REGEXP_CONTROL_CHARS.add(new Character('&'));
        REGEXP_CONTROL_CHARS.add(new Character('<'));
        REGEXP_CONTROL_CHARS.add(new Character('>'));
        REGEXP_CONTROL_CHARS.add(new Character('='));
        REGEXP_CONTROL_CHARS.add(new Character('!'));
    }

    static class LikeExpression
    extends UnaryExpression
    implements BooleanExpression {
        Pattern likePattern;

        public LikeExpression(Expression expression, String string, int n) {
            super(expression);
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            stringBuffer.append("\\A");
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (n == (0xFFFF & c)) {
                    if (++i >= string.length()) break;
                    char c2 = string.charAt(i);
                    stringBuffer.append("\\x");
                    stringBuffer.append(Integer.toHexString(0xFFFF & c2));
                    continue;
                }
                if (c == '%') {
                    stringBuffer.append(".*?");
                    continue;
                }
                if (c == '_') {
                    stringBuffer.append(".");
                    continue;
                }
                if (REGEXP_CONTROL_CHARS.contains(new Character(c))) {
                    stringBuffer.append("\\x");
                    stringBuffer.append(Integer.toHexString(0xFFFF & c));
                    continue;
                }
                stringBuffer.append(c);
            }
            stringBuffer.append("\\Z");
            try {
                this.likePattern = new Perl5Compiler().compile(stringBuffer.toString(), 48);
            }
            catch (MalformedPatternException malformedPatternException) {
                throw new RuntimeException(malformedPatternException.getMessage());
            }
        }

        @Override
        public String getExpressionSymbol() {
            return "LIKE";
        }

        @Override
        public Object evaluate(Message message) throws JMSException {
            Object object = this.getRight().evaluate(message);
            if (object == null) {
                return null;
            }
            if (!(object instanceof String)) {
                return Boolean.FALSE;
            }
            return new Perl5Matcher().matches((String)object, this.likePattern) ? Boolean.TRUE : Boolean.FALSE;
        }
    }
}

