/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.util.common.ArrayUtil;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MockMapMessage
extends MockMessage
implements MapMessage {
    private Map data = new HashMap();

    public boolean getBoolean(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Boolean.valueOf(null);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to boolean");
    }

    public byte getByte(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Byte.valueOf(null);
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof String) {
            return Byte.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to byte");
    }

    public short getShort(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Short.valueOf(null);
        }
        if (object instanceof Byte || object instanceof Short) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            return Short.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to short");
    }

    public char getChar(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            throw new NullPointerException();
        }
        if (!(object instanceof Character)) {
            throw new MessageFormatException(object.getClass().getName() + " cannot be converted to char");
        }
        return ((Character)object).charValue();
    }

    public int getInt(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Integer.valueOf(null);
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to int");
    }

    public long getLong(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Long.valueOf(null);
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to long");
    }

    public float getFloat(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Float.valueOf(null).floatValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof String) {
            return Float.valueOf((String)object).floatValue();
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to float");
    }

    public double getDouble(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return Double.valueOf(null);
        }
        if (object instanceof Double || object instanceof Float) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        throw new MessageFormatException(object.getClass().getName() + " cannot be converted to double");
    }

    public String getString(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            return null;
        }
        if (object instanceof byte[]) {
            throw new MessageFormatException(object.getClass().getName() + " cannot be converted to String");
        }
        return object.toString();
    }

    public byte[] getBytes(String string) throws JMSException {
        Object object = this.getObject(string);
        if (null == object) {
            throw new NullPointerException();
        }
        if (!(object instanceof byte[])) {
            throw new MessageFormatException(object.getClass().getName() + " cannot be converted to byte[]");
        }
        return (byte[])object;
    }

    public Object getObject(String string) throws JMSException {
        return this.data.get(string);
    }

    public Enumeration getMapNames() throws JMSException {
        return new Vector(this.data.keySet()).elements();
    }

    public void setBoolean(String string, boolean bl) throws JMSException {
        this.setObject(string, new Boolean(bl));
    }

    public void setByte(String string, byte by) throws JMSException {
        this.setObject(string, new Byte(by));
    }

    public void setShort(String string, short s) throws JMSException {
        this.setObject(string, new Short(s));
    }

    public void setChar(String string, char c) throws JMSException {
        this.setObject(string, new Character(c));
    }

    public void setInt(String string, int n) throws JMSException {
        this.setObject(string, new Integer(n));
    }

    public void setLong(String string, long l) throws JMSException {
        this.setObject(string, new Long(l));
    }

    public void setFloat(String string, float f) throws JMSException {
        this.setObject(string, new Float(f));
    }

    public void setDouble(String string, double d) throws JMSException {
        this.setObject(string, new Double(d));
    }

    public void setString(String string, String string2) throws JMSException {
        this.setObject(string, string2);
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        byte[] byArray2 = (byte[])byArray.clone();
        this.setObject(string, byArray2);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (null == byArray) {
            this.setObject(string, null);
            return;
        }
        this.setBytes(string, (byte[])ArrayUtil.truncateArray(byArray, n, n2));
    }

    public void setObject(String string, Object object) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == string || string.length() <= 0) {
            throw new IllegalArgumentException("Property names must not be null or empty strings");
        }
        if (null == object) {
            return;
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof String || object instanceof byte[]) {
            this.data.put(string, object);
            return;
        }
        throw new MessageFormatException(object.getClass().getName() + " not a valid type");
    }

    public boolean itemExists(String string) throws JMSException {
        return this.data.containsKey(string);
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.data.clear();
    }

    public Map getMap() {
        HashMap hashMap = new HashMap();
        this.copyDataToMap(hashMap);
        return hashMap;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof MockMapMessage)) {
            return false;
        }
        MockMapMessage mockMapMessage = (MockMapMessage)object;
        if (this.data.size() != mockMapMessage.data.size()) {
            return false;
        }
        for (Object k : this.data.keySet()) {
            Object v = this.data.get(k);
            Object v2 = mockMapMessage.data.get(k);
            if (null == v) {
                if (null == v2) continue;
                return false;
            }
            if (v instanceof byte[]) {
                if (null == v2) {
                    return false;
                }
                if (!(v2 instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])v, (byte[])v2)) continue;
                return false;
            }
            if (v.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        for (Object v : this.data.values()) {
            if (v instanceof byte[]) {
                for (int i = 0; i < ((byte[])v).length; ++i) {
                    n = 31 * n + ((byte[])v)[i];
                }
                continue;
            }
            if (v == null) continue;
            n = 31 * n + v.hashCode();
        }
        return n;
    }

    @Override
    public Object clone() {
        MockMapMessage mockMapMessage = (MockMapMessage)super.clone();
        mockMapMessage.data = new HashMap(this.data.size());
        this.copyDataToMap(mockMapMessage.data);
        return mockMapMessage;
    }

    private void copyDataToMap(Map map) {
        for (Object k : this.data.keySet()) {
            Object v = this.data.get(k);
            if (v instanceof byte[]) {
                map.put(k, ((byte[])v).clone());
                continue;
            }
            map.put(k, v);
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.data.toString();
    }
}

