/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class MockSQLXML
implements SQLXML,
Cloneable {
    private DocumentBuilder domParser;
    private SAXParser saxParser;
    private XMLOutputFactory outputFactory;
    private XMLInputFactory inputFactory;
    private SAXBuilder jdomParser;
    private DOMBuilder jdomDOMBuilder;
    private XMLOutputter xmlPrintOutputter;
    private DOMOutputter domOutputter;
    private XMLOutputter xmlCompareOutputter;
    private Object content;
    private boolean wasFreeCalled;
    private boolean wasWriteMethodCalled;
    private boolean wasReadMethodCalled;

    public MockSQLXML() {
        this.createXMLObjects();
        this.content = null;
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(String string) {
        this.createXMLObjects();
        this.content = string;
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(Reader reader) {
        this.createXMLObjects();
        this.content = StreamUtil.getReaderAsString(reader);
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(InputStream inputStream) {
        this.createXMLObjects();
        this.content = StreamUtil.getStreamAsByteArray(inputStream);
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(org.w3c.dom.Document document) {
        this.createXMLObjects();
        this.content = document;
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    protected DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new NestedApplicationException(parserConfigurationException);
        }
    }

    protected SAXParser createSAXParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    protected XMLOutputFactory createXMLOutputFactory() {
        return XMLOutputFactory.newInstance();
    }

    protected XMLInputFactory createXMLInputFactory() {
        return XMLInputFactory.newInstance();
    }

    protected SAXBuilder createJDOMSAXBuilder() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setValidation(false);
        return sAXBuilder;
    }

    protected DOMBuilder createJDOMDOMBuilder() {
        return new DOMBuilder();
    }

    protected XMLOutputter createJDOMXMLPrintOutputter() {
        return new XMLOutputter(Format.getPrettyFormat());
    }

    protected XMLOutputter createJDOMXMLCompareOutputter() {
        Format format = Format.getCompactFormat();
        format.setOmitDeclaration(true);
        format.setOmitEncoding(true);
        return new XMLOutputter(format);
    }

    protected DOMOutputter createJDOMDOMOutputter() {
        return new DOMOutputter();
    }

    public String getContentAsString() {
        try {
            return this.contentToString();
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public InputStream getContentAsInputStream() throws SQLException {
        try {
            return this.contentToInputStream();
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public Reader getContentAsReader() throws SQLException {
        try {
            return this.contentToReader();
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public org.w3c.dom.Document getContentAsW3CDocument() {
        try {
            return this.contentToW3CDocument();
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            return this.contentToInputStream();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            return this.contentToReader();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public Source getSource(Class clazz) throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            if (null == clazz || StreamSource.class.equals((Object)clazz)) {
                return new StreamSource(this.contentToInputStream());
            }
            if (DOMSource.class.equals((Object)clazz)) {
                return new DOMSource(this.contentToW3CDocument());
            }
            if (SAXSource.class.equals((Object)clazz)) {
                return new SAXSource(this.saxParser.getXMLReader(), new InputSource(this.contentToInputStream()));
            }
            if (StAXSource.class.equals((Object)clazz)) {
                return new StAXSource(this.contentToXMLStreamReader());
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
        throw new SQLException(clazz.getName() + " not supported as Source");
    }

    @Override
    public String getString() throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            return this.contentToString();
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        this.content = new ByteArrayOutputStream();
        return (OutputStream)this.content;
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        this.content = new StringWriter();
        return (Writer)this.content;
    }

    public Result setResult(Class clazz) throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        if (null == clazz || StreamResult.class.equals((Object)clazz)) {
            this.content = new ByteArrayOutputStream();
            return new StreamResult((OutputStream)this.content);
        }
        if (DOMResult.class.equals((Object)clazz)) {
            org.w3c.dom.Document document = this.domParser.newDocument();
            this.content = new DOMResult(document);
            return (DOMResult)this.content;
        }
        if (SAXResult.class.equals((Object)clazz)) {
            this.content = new SAXHandler();
            return new SAXResult((ContentHandler)((SAXHandler)this.content));
        }
        if (StAXResult.class.equals((Object)clazz)) {
            XMLStreamWriter xMLStreamWriter;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                xMLStreamWriter = this.outputFactory.createXMLStreamWriter(byteArrayOutputStream);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SQLException(xMLStreamException);
            }
            this.content = new StreamWriterOutputStreamMapping(xMLStreamWriter, byteArrayOutputStream);
            return new StAXResult(xMLStreamWriter);
        }
        throw new SQLException(clazz.getName() + " not supported as Result");
    }

    @Override
    public void setString(String string) throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        this.content = string;
    }

    @Override
    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean isReadable() {
        return !this.wasFreeCalled && !this.wasReadMethodCalled;
    }

    public boolean isWriteable() {
        return !this.wasFreeCalled && !this.wasWriteMethodCalled;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MockSQLXML mockSQLXML = (MockSQLXML)object;
        if (this.wasFreeCalled != mockSQLXML.wasFreeCalled()) {
            return false;
        }
        if (null == this.content && null == mockSQLXML.content) {
            return true;
        }
        if (null == this.content || null == mockSQLXML.content) {
            return false;
        }
        try {
            Document document = this.contentToJDOMDocument();
            Document document2 = mockSQLXML.contentToJDOMDocument();
            if (null == document || null == document2) {
                return false;
            }
            String string = this.xmlCompareOutputter.outputString(document);
            String string2 = this.xmlCompareOutputter.outputString(document2);
            return string.equals(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        int n = 17;
        if (null != this.content) {
            try {
                Document document = this.contentToJDOMDocument();
                if (null == document) {
                    return n;
                }
                String string = this.xmlCompareOutputter.outputString(document);
                if (null != string) {
                    n = 31 * n + string.hashCode();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n = 31 * n + (this.wasFreeCalled ? 31 : 62);
        return n;
    }

    public Object clone() {
        try {
            MockSQLXML mockSQLXML = (MockSQLXML)super.clone();
            mockSQLXML.domParser = this.createDocumentBuilder();
            mockSQLXML.saxParser = this.createSAXParser();
            mockSQLXML.outputFactory = this.createXMLOutputFactory();
            mockSQLXML.inputFactory = this.createXMLInputFactory();
            mockSQLXML.jdomParser = this.createJDOMSAXBuilder();
            mockSQLXML.jdomDOMBuilder = this.createJDOMDOMBuilder();
            mockSQLXML.xmlPrintOutputter = this.createJDOMXMLPrintOutputter();
            mockSQLXML.domOutputter = this.createJDOMDOMOutputter();
            mockSQLXML.xmlCompareOutputter = this.createJDOMXMLCompareOutputter();
            if (null != this.content) {
                try {
                    Document document = this.contentToJDOMDocument();
                    mockSQLXML.content = document.clone();
                }
                catch (Exception exception) {
                    mockSQLXML.content = null;
                }
            }
            return mockSQLXML;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("XML data:\n");
        if (null == this.content) {
            stringBuffer.append("null");
        } else {
            try {
                Document document = this.contentToJDOMDocument();
                if (null != document) {
                    stringBuffer.append(document.toString());
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    private void createXMLObjects() {
        this.domParser = this.createDocumentBuilder();
        this.saxParser = this.createSAXParser();
        this.outputFactory = this.createXMLOutputFactory();
        this.inputFactory = this.createXMLInputFactory();
        this.jdomParser = this.createJDOMSAXBuilder();
        this.jdomDOMBuilder = this.createJDOMDOMBuilder();
        this.xmlPrintOutputter = this.createJDOMXMLPrintOutputter();
        this.domOutputter = this.createJDOMDOMOutputter();
        this.xmlCompareOutputter = this.createJDOMXMLCompareOutputter();
    }

    private void verifyWrite() throws SQLException {
        if (!this.isWriteable()) {
            throw new SQLException("not writeable");
        }
    }

    private void verifyRead() throws SQLException {
        if (!this.isReadable()) {
            throw new SQLException("not readable");
        }
        if (null == this.content) {
            throw new SQLException("no content");
        }
    }

    private Document contentToJDOMDocument() throws Exception {
        Document document = null;
        if (this.content instanceof Document) {
            document = (Document)this.content;
        } else if (this.content instanceof String) {
            document = this.jdomParser.build((Reader)new StringReader((String)this.content));
        } else if (this.content instanceof StringWriter) {
            document = this.jdomParser.build((Reader)new StringReader(((StringWriter)this.content).toString()));
        } else if (this.content instanceof ByteArrayOutputStream) {
            document = this.jdomParser.build((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)this.content).toByteArray()));
        } else if (this.content instanceof byte[]) {
            document = this.jdomParser.build((InputStream)new ByteArrayInputStream((byte[])this.content));
        } else if (this.content instanceof org.w3c.dom.Document) {
            document = this.jdomDOMBuilder.build((org.w3c.dom.Document)this.content);
        } else if (this.content instanceof DOMResult) {
            Node node = ((DOMResult)this.content).getNode();
            org.w3c.dom.Document document2 = null;
            if (node instanceof org.w3c.dom.Document) {
                document2 = (org.w3c.dom.Document)node;
            } else {
                document2 = this.domParser.newDocument();
                document2.appendChild(document2.importNode(node, true));
            }
            document = this.jdomDOMBuilder.build(document2);
        } else if (this.content instanceof SAXHandler) {
            document = ((SAXHandler)this.content).getDocument();
        } else if (this.content instanceof StreamWriterOutputStreamMapping) {
            XMLStreamWriter xMLStreamWriter = ((StreamWriterOutputStreamMapping)this.content).getStreamWriter();
            xMLStreamWriter.flush();
            xMLStreamWriter.close();
            ByteArrayOutputStream byteArrayOutputStream = ((StreamWriterOutputStreamMapping)this.content).getOutputStream();
            document = this.jdomParser.build((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        return document;
    }

    private String contentToString() throws Exception {
        Document document = this.contentToJDOMDocument();
        if (null != document) {
            return this.xmlPrintOutputter.outputString(document);
        }
        return null;
    }

    private Reader contentToReader() throws Exception {
        Document document = this.contentToJDOMDocument();
        if (null != document) {
            return new StringReader(this.xmlPrintOutputter.outputString(document));
        }
        return null;
    }

    private InputStream contentToInputStream() throws Exception {
        Document document = this.contentToJDOMDocument();
        if (null != document) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.xmlPrintOutputter.output(document, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return null;
    }

    private org.w3c.dom.Document contentToW3CDocument() throws Exception {
        Document document = this.contentToJDOMDocument();
        if (null != document) {
            return this.domOutputter.output(document);
        }
        return null;
    }

    private XMLStreamReader contentToXMLStreamReader() throws Exception {
        Document document = this.contentToJDOMDocument();
        if (null != document) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.xmlPrintOutputter.output(document, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return this.inputFactory.createXMLStreamReader(byteArrayInputStream);
        }
        return null;
    }

    private class StreamWriterOutputStreamMapping {
        private XMLStreamWriter streamWriter;
        private ByteArrayOutputStream outputStream;

        public StreamWriterOutputStreamMapping(XMLStreamWriter xMLStreamWriter, ByteArrayOutputStream byteArrayOutputStream) {
            this.streamWriter = xMLStreamWriter;
            this.outputStream = byteArrayOutputStream;
        }

        public XMLStreamWriter getStreamWriter() {
            return this.streamWriter;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

