/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.ParameterUtil;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockResultSetMetaData;
import com.mockrunner.mock.jdbc.MockRowId;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockStatement;
import com.mockrunner.util.common.CaseAwareMap;
import com.mockrunner.util.common.CollectionUtil;
import com.mockrunner.util.common.StreamUtil;
import com.mockrunner.util.common.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MockResultSet
implements ResultSet,
Cloneable {
    private Statement statement;
    private String id;
    private Map columnMap;
    private Map columnMapCopy;
    private Map insertRow;
    private List columnNameList;
    private List updatedRows;
    private List deletedRows;
    private List insertedRows;
    private int cursor;
    private boolean isCursorInInsertRow;
    private boolean wasNull;
    private String cursorName;
    private int fetchSize = 0;
    private int fetchDirection = 1000;
    private int resultSetType = 1004;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;
    private boolean isDatabaseView;
    private ResultSetMetaData resultSetMetaData;
    private boolean closed;
    private boolean columnsCaseSensitive;

    public MockResultSet(String string) {
        this(string, "");
    }

    public MockResultSet(String string, String string2) {
        this.init();
        this.cursorName = string2;
        this.id = string;
        this.columnsCaseSensitive = false;
    }

    private void init() {
        this.columnMap = this.createCaseAwareMap();
        this.columnNameList = new ArrayList();
        this.updatedRows = new ArrayList();
        this.deletedRows = new ArrayList();
        this.insertedRows = new ArrayList();
        this.cursor = -1;
        this.wasNull = false;
        this.closed = false;
        this.isCursorInInsertRow = false;
        this.isDatabaseView = false;
        this.resultSetMetaData = null;
        this.copyColumnMap();
        this.adjustInsertRow();
    }

    public void setColumnsCaseSensitive(boolean bl) {
        this.columnsCaseSensitive = bl;
        this.init();
    }

    public Object clone() {
        try {
            MockResultSet mockResultSet = (MockResultSet)super.clone();
            mockResultSet.columnNameList = new ArrayList(this.columnNameList);
            mockResultSet.updatedRows = new ArrayList(this.updatedRows);
            mockResultSet.deletedRows = new ArrayList(this.deletedRows);
            mockResultSet.insertedRows = new ArrayList(this.insertedRows);
            mockResultSet.insertRow = this.copyColumnDataMap(this.insertRow);
            mockResultSet.columnMap = this.copyColumnDataMap(this.columnMap);
            mockResultSet.columnMapCopy = this.copyColumnDataMap(this.columnMapCopy);
            if (null != this.resultSetMetaData && this.resultSetMetaData instanceof MockResultSetMetaData) {
                mockResultSet.resultSetMetaData = (ResultSetMetaData)((MockResultSetMetaData)this.resultSetMetaData).clone();
            }
            return mockResultSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
        try {
            this.fetchDirection = statement.getFetchDirection();
            this.resultSetType = statement.getResultSetType();
            this.resultSetConcurrency = statement.getResultSetConcurrency();
            this.resultSetHoldability = statement.getResultSetHoldability();
            this.fetchSize = statement.getFetchSize();
            this.cursorName = ((MockStatement)statement).getCursorName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setCursorName(String string) {
        this.cursorName = string;
    }

    public void setResultSetType(int n) {
        this.resultSetType = n;
    }

    public void setResultSetConcurrency(int n) {
        this.resultSetConcurrency = n;
    }

    public void setResultSetHoldability(int n) {
        this.resultSetHoldability = n;
    }

    public void setDatabaseView(boolean bl) {
        this.isDatabaseView = bl;
    }

    public void addRow(Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.addRow(list);
    }

    public void addRow(List list) {
        int n;
        int n2 = list.size() - this.columnNameList.size();
        for (n = 0; n < n2; ++n) {
            this.addColumn();
        }
        this.adjustColumns();
        for (n = 0; n < list.size(); ++n) {
            Object e = list.get(n);
            String string = (String)this.columnNameList.get(n);
            List list2 = (List)this.columnMap.get(string);
            list2.add(e);
        }
        this.adjustColumns();
        this.copyColumnMap();
        this.adjustFlags();
    }

    public void addColumn() {
        this.addColumn(this.determineValidColumnName());
    }

    public void addColumn(String string) {
        this.addColumn(string, new ArrayList());
    }

    public void addColumn(Object[] objectArray) {
        this.addColumn(this.determineValidColumnName(), objectArray);
    }

    public void addColumn(List list) {
        this.addColumn(this.determineValidColumnName(), list);
    }

    public void addColumn(String string, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        this.addColumn(string, list);
    }

    public void addColumn(String string, List list) {
        ArrayList arrayList = new ArrayList(list);
        this.columnMap.put(string, arrayList);
        this.columnNameList.add(string);
        this.adjustColumns();
        this.adjustInsertRow();
        this.copyColumnMap();
        this.adjustFlags();
    }

    public int getRowCount() {
        if (this.columnMapCopy.size() == 0) {
            return 0;
        }
        List list = (List)this.columnMapCopy.values().iterator().next();
        return list.size();
    }

    public int getColumnCount() {
        return this.columnMapCopy.size();
    }

    public boolean rowInserted(int n) {
        if (n < 1) {
            return false;
        }
        return (Boolean)this.insertedRows.get(n - 1);
    }

    public boolean rowDeleted(int n) {
        if (n < 1) {
            return false;
        }
        return (Boolean)this.deletedRows.get(n - 1);
    }

    public boolean rowUpdated(int n) {
        if (n < 1) {
            return false;
        }
        return (Boolean)this.updatedRows.get(n - 1);
    }

    public boolean isRowEqual(int n, List list) {
        List list2 = this.getRow(n);
        if (null == list2) {
            return false;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object object = list2.get(i);
            Object object2 = list.get(i);
            if (null != object && null != object2 && !object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                object = object.toString();
                object2 = object2.toString();
            }
            if (ParameterUtil.compareParameter(object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEqual(int n, List list) {
        List list2 = this.getColumn(n);
        if (null == list2) {
            return false;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object object = list2.get(i);
            Object object2 = list.get(i);
            if (null != object && null != object2 && !object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                object = object.toString();
                object2 = object2.toString();
            }
            if (ParameterUtil.compareParameter(object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnEqual(String string, List list) {
        List list2 = this.getColumn(string);
        if (null == list2) {
            return false;
        }
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            Object object = list2.get(i);
            Object object2 = list.get(i);
            if (null != object && null != object2 && !object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                object = object.toString();
                object2 = object2.toString();
            }
            if (ParameterUtil.compareParameter(object, object2)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(MockResultSet mockResultSet) {
        if (null == mockResultSet) {
            return false;
        }
        Map map = this.isDatabaseView ? this.columnMap : this.columnMapCopy;
        Map map2 = mockResultSet.isDatabaseView ? mockResultSet.columnMap : mockResultSet.columnMapCopy;
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            List list2 = (List)map2.get(string);
            if (null == list2) {
                return false;
            }
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                Object object2 = list2.get(i);
                if (null != object && null != object2 && !object.getClass().isAssignableFrom(object2.getClass()) && !object2.getClass().isAssignableFrom(object.getClass())) {
                    object = object.toString();
                    object2 = object2.toString();
                }
                if (ParameterUtil.compareParameter(object, object2)) continue;
                return false;
            }
        }
        return true;
    }

    public List getRow(int n) {
        if (n > this.getRowCount()) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        int n2 = n - 1;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            String string = (String)this.columnNameList.get(i);
            List list = this.isDatabaseView ? (List)this.columnMap.get(string) : (List)this.columnMapCopy.get(string);
            arrayList.add(list.get(n2));
        }
        return arrayList;
    }

    public List getColumn(int n) {
        if (n > this.getColumnCount()) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        int n2 = n - 1;
        String string = (String)this.columnNameList.get(n2);
        return this.getColumn(string);
    }

    public List getColumn(String string) {
        ArrayList arrayList = new ArrayList();
        List list = this.isDatabaseView ? (List)this.columnMap.get(string) : (List)this.columnMapCopy.get(string);
        if (null == list) {
            return null;
        }
        arrayList.addAll(list);
        return arrayList;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkColumnBounds(n);
        this.checkRowBounds();
        String string = (String)this.columnNameList.get(n - 1);
        return this.getObject(string);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        this.checkColumnName(string);
        this.checkRowBounds();
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        List list = this.isDatabaseView ? (List)this.columnMap.get(string) : (List)this.columnMapCopy.get(string);
        Object e = list.get(this.cursor);
        this.wasNull = null == e;
        return e;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    @Override
    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    @Override
    public String getString(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return new Boolean(object.toString());
        }
        return false;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return new Boolean(object.toString());
        }
        return false;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            return new Byte(object.toString());
        }
        return 0;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            return new Byte(object.toString());
        }
        return 0;
    }

    @Override
    public short getShort(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            return new Short(object.toString());
        }
        return 0;
    }

    @Override
    public short getShort(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            return new Short(object.toString());
        }
        return 0;
    }

    @Override
    public int getInt(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return new Integer(object.toString());
        }
        return 0;
    }

    @Override
    public int getInt(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return new Integer(object.toString());
        }
        return 0;
    }

    @Override
    public long getLong(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return new Long(object.toString());
        }
        return 0L;
    }

    @Override
    public long getLong(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return new Long(object.toString());
        }
        return 0L;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            return new Float(object.toString()).floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            return new Float(object.toString()).floatValue();
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return new Double(object.toString());
        }
        return 0.0;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return new Double(object.toString());
        }
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n2);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(string);
        if (null != bigDecimal) {
            return bigDecimal.setScale(n);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        return null;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            try {
                return object.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NestedApplicationException(unsupportedEncodingException);
            }
        }
        return null;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            try {
                return object.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NestedApplicationException(unsupportedEncodingException);
            }
        }
        return null;
    }

    @Override
    public Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            return Date.valueOf(object.toString());
        }
        return null;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            return Date.valueOf(object.toString());
        }
        return null;
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Time) {
                return (Time)object;
            }
            return Time.valueOf(object.toString());
        }
        return null;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Time) {
                return (Time)object;
            }
            return Time.valueOf(object.toString());
        }
        return null;
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(string);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            return Timestamp.valueOf(object.toString());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            return Timestamp.valueOf(object.toString());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(string);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof URL) {
                return (URL)object;
            }
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof URL) {
                return (URL)object;
            }
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Blob) {
                return (Blob)object;
            }
            return new MockBlob(this.getBytes(n));
        }
        return null;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Blob) {
                return (Blob)object;
            }
            return new MockBlob(this.getBytes(string));
        }
        return null;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Clob) {
                return (Clob)object;
            }
            return new MockClob(this.getString(n));
        }
        return null;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Clob) {
                return (Clob)object;
            }
            return new MockClob(this.getString(string));
        }
        return null;
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof NClob) {
                return (NClob)object;
            }
            if (object instanceof Clob) {
                return this.getNClobFromClob((Clob)object);
            }
            return new MockNClob(this.getString(n));
        }
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof NClob) {
                return (NClob)object;
            }
            if (object instanceof Clob) {
                return this.getNClobFromClob((Clob)object);
            }
            return new MockNClob(this.getString(string));
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof SQLXML) {
                return (SQLXML)object;
            }
            return new MockSQLXML(this.getString(n));
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof SQLXML) {
                return (SQLXML)object;
            }
            return new MockSQLXML(this.getString(string));
        }
        return null;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Array) {
                return (Array)object;
            }
            return new MockArray(object);
        }
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Array) {
                return (Array)object;
            }
            return new MockArray(object);
        }
        return null;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Ref) {
                return (Ref)object;
            }
            return new MockRef(object);
        }
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Ref) {
                return (Ref)object;
            }
            return new MockRef(object);
        }
        return null;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof RowId) {
                return (RowId)object;
            }
            return new MockRowId(this.getBytes(n));
        }
        return null;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof RowId) {
                return (RowId)object;
            }
            return new MockRowId(this.getBytes(string));
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getBinaryStream(string);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            return new ByteArrayInputStream(this.getBytes(n));
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            return new ByteArrayInputStream(this.getBytes(string));
        }
        return null;
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            try {
                return new ByteArrayInputStream(this.getString(n).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NestedApplicationException(unsupportedEncodingException);
            }
        }
        return null;
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            try {
                return new ByteArrayInputStream(this.getString(string).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NestedApplicationException(unsupportedEncodingException);
            }
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Reader) {
                return (Reader)object;
            }
            return new StringReader(this.getString(n));
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Reader) {
                return (Reader)object;
            }
            return new StringReader(this.getString(string));
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(string);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.cursorName;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (null != this.resultSetMetaData) {
            return this.resultSetMetaData;
        }
        MockResultSetMetaData mockResultSetMetaData = new MockResultSetMetaData();
        mockResultSetMetaData.setColumnCount(this.getColumnCount());
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            mockResultSetMetaData.setColumnName(i + 1, (String)this.columnNameList.get(i));
        }
        return mockResultSetMetaData;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getRowCount() != 0 && this.cursor == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.cursor >= this.getRowCount();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.cursor == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.cursor != -1 && this.cursor == this.getRowCount() - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        this.cursor = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return;
        }
        this.cursor = this.getRowCount();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.getRowCount() == 0) {
            return false;
        }
        ++this.cursor;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = 0;
        return true;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor = this.getRowCount() - 1;
        return true;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        if (n > 0) {
            this.cursor = n - 1;
        }
        if (n < 0) {
            this.cursor = this.getRowCount() + n;
        }
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        this.cursor += n;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public int getRow() throws SQLException {
        return this.cursor + 1;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetType();
        if (this.getRowCount() == 0) {
            return false;
        }
        --this.cursor;
        this.adjustCursor();
        return this.isCurrentRowValid();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkFetchDirectionArguments(n);
        if (this.fetchDirection == n) {
            return;
        }
        if (this.fetchDirection == 1002 || n == 1002) {
            this.fetchDirection = n;
            return;
        }
        this.fetchDirection = n;
        for (List list : this.columnMapCopy.values()) {
            Collections.reverse(list);
        }
        if (-1 != this.cursor) {
            this.cursor = this.getRowCount() - this.cursor - 1;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        for (int i = 0; i < this.columnNameList.size(); ++i) {
            if (!string.equals(this.columnNameList.get(i))) continue;
            return i + 1;
        }
        throw new SQLException("No column with name " + string + " found");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.checkColumnBounds(n);
        if (!this.isCursorInInsertRow) {
            this.checkRowBounds();
            if (this.rowDeleted()) {
                throw new SQLException("row was deleted");
            }
        }
        String string = (String)this.columnNameList.get(n - 1);
        this.updateObject(string, object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(string, object);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.checkColumnName(string);
        this.checkResultSetConcurrency();
        if (!this.isCursorInInsertRow) {
            this.checkRowBounds();
            if (this.rowDeleted()) {
                throw new SQLException("row was deleted");
            }
        }
        if (this.isCursorInInsertRow) {
            List list = (List)this.insertRow.get(string);
            list.set(0, object);
        } else {
            List list = (List)this.columnMapCopy.get(string);
            list.set(this.cursor, object);
        }
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateObject(string, (Object)string2);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateObject(string, (Object)string2);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateObject(string, null);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateObject(string, (Object)new Boolean(bl));
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateObject(string, (Object)new Byte(by));
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateObject(string, (Object)new Short(s));
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateObject(string, (Object)new Integer(n));
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateObject(string, (Object)new Long(l));
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateObject(string, (Object)new Float(f));
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateObject(string, (Object)new Double(d));
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(string, (Object)bigDecimal);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateObject(string, (Object)byArray);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateObject(string, (Object)date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateObject(string, (Object)time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateObject(string, (Object)timestamp);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(string, inputStream, n);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(string, inputStream, l);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(string, inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, n2);
        this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, n);
        this.updateObject(string, (Object)new ByteArrayInputStream(byArray));
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(string, inputStream, (int)l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
        this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
        this.updateObject(string, (Object)new ByteArrayInputStream(byArray));
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader, n2);
        this.updateObject(n, (Object)new StringReader(string));
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader, n);
        this.updateObject(string, (Object)new StringReader(string2));
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, (int)l);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string, reader, (int)l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader);
        this.updateObject(n, (Object)new StringReader(string));
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader);
        this.updateObject(string, (Object)new StringReader(string2));
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(string, reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(string, reader, l);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateObject(string, (Object)ref);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.updateObject(n, (Object)rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateObject(string, (Object)rowId);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateObject(string, (Object)blob);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, (int)l);
        this.updateBlob(n, (Blob)new MockBlob(byArray));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, (int)l);
        this.updateBlob(string, (Blob)new MockBlob(byArray));
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
        this.updateBlob(n, (Blob)new MockBlob(byArray));
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream);
        this.updateBlob(string, (Blob)new MockBlob(byArray));
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateObject(string, (Object)clob);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader, (int)l);
        this.updateClob(n, (Clob)new MockClob(string));
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader, (int)l);
        this.updateClob(string, (Clob)new MockClob(string2));
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader);
        this.updateClob(n, (Clob)new MockClob(string));
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader);
        this.updateClob(string, (Clob)new MockClob(string2));
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateObject(n, (Object)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateObject(string, (Object)nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader, (int)l);
        this.updateNClob(n, (NClob)new MockNClob(string));
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader, (int)l);
        this.updateNClob(string, (NClob)new MockNClob(string2));
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        String string = StreamUtil.getReaderAsString(reader);
        this.updateNClob(n, (NClob)new MockNClob(string));
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader);
        this.updateNClob(string, (NClob)new MockNClob(string2));
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.updateObject(n, (Object)sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateObject(string, (Object)sQLXML);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateObject(string, (Object)array);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkRowBounds();
        return (Boolean)this.updatedRows.get(this.cursor);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkRowBounds();
        return (Boolean)this.insertedRows.get(this.cursor);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkRowBounds();
        return (Boolean)this.deletedRows.get(this.cursor);
    }

    @Override
    public void insertRow() throws SQLException {
        if (!this.isCursorInInsertRow) {
            throw new SQLException("cursor is not in insert row");
        }
        this.checkResultSetConcurrency();
        this.insertRow(this.cursor);
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        this.checkResultSetConcurrency();
        this.checkRowBounds();
        this.updateRow(this.cursor, true);
        this.updatedRows.set(this.cursor, new Boolean(true));
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        this.checkResultSetConcurrency();
        this.checkRowBounds();
        this.deleteRow(this.cursor);
        this.deletedRows.set(this.cursor, new Boolean(true));
    }

    @Override
    public void refreshRow() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (this.isCursorInInsertRow) {
            throw new SQLException("cursor is in insert row");
        }
        if (this.rowDeleted()) {
            throw new SQLException("row was deleted");
        }
        this.checkRowBounds();
        this.updateRow(this.cursor, false);
        this.updatedRows.set(this.cursor, new Boolean(false));
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.adjustCursorForInsert();
        this.isCursorInInsertRow = true;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.isCursorInInsertRow = false;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return false;
    }

    public Object unwrap(Class clazz) throws SQLException {
        throw new SQLException("No object found for " + clazz);
    }

    private void checkColumnName(String string) throws SQLException {
        if (!this.columnMap.containsKey(string)) {
            throw new SQLException("No column " + string);
        }
    }

    private void checkColumnBounds(int n) throws SQLException {
        if (n - 1 >= this.columnNameList.size()) {
            throw new SQLException("Index " + n + " out of bounds");
        }
    }

    private void checkRowBounds() throws SQLException {
        if (!this.isCurrentRowValid()) {
            throw new SQLException("Current row invalid");
        }
    }

    private boolean isCurrentRowValid() {
        return this.cursor < this.getRowCount() && -1 != this.cursor;
    }

    private void checkResultSetType() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLException("ResultSet is TYPE_FORWARD_ONLY");
        }
    }

    private void checkResultSetConcurrency() throws SQLException {
        if (this.resultSetConcurrency == 1007) {
            throw new SQLException("ResultSet is CONCUR_READ_ONLY");
        }
    }

    private void checkFetchDirectionArguments(int n) throws SQLException {
        SQLUtil.checkFetchDirection(n);
        if (this.resultSetType == 1003 && n != 1000) {
            throw new SQLException("resultSetType is TYPE_FORWARD_ONLY, only FETCH_FORWARD allowed");
        }
    }

    private void insertRow(int n) {
        for (String string : this.columnMapCopy.keySet()) {
            List list = (List)this.columnMapCopy.get(string);
            List list2 = (List)this.columnMap.get(string);
            List list3 = (List)this.insertRow.get(string);
            list.add(n, ParameterUtil.copyParameter(list3.get(0)));
            list2.add(n, ParameterUtil.copyParameter(list3.get(0)));
        }
        this.updatedRows.add(n, new Boolean(false));
        this.deletedRows.add(n, new Boolean(false));
        this.insertedRows.add(n, new Boolean(true));
    }

    private void deleteRow(int n) {
        for (String string : this.columnMapCopy.keySet()) {
            List list = (List)this.columnMapCopy.get(string);
            List list2 = (List)this.columnMap.get(string);
            list.set(n, null);
            list2.set(n, null);
        }
    }

    private void updateRow(int n, boolean bl) {
        for (String string : this.columnMapCopy.keySet()) {
            List list;
            List list2;
            if (bl) {
                list2 = (List)this.columnMapCopy.get(string);
                list = (List)this.columnMap.get(string);
            } else {
                list2 = (List)this.columnMap.get(string);
                list = (List)this.columnMapCopy.get(string);
            }
            list.set(n, ParameterUtil.copyParameter(list2.get(n)));
        }
    }

    private void adjustCursorForInsert() {
        if (this.cursor >= this.getRowCount()) {
            this.cursor = this.getRowCount() - 1;
        }
        if (this.cursor < 0) {
            this.cursor = 0;
        }
    }

    private void adjustCursor() {
        if (this.cursor < 0) {
            this.cursor = -1;
        }
        if (this.cursor >= this.getRowCount()) {
            this.cursor = this.getRowCount();
        }
    }

    private void adjustColumns() {
        int n = 0;
        for (List list : this.columnMap.values()) {
            n = Math.max(n, list.size());
        }
        for (List list : this.columnMap.values()) {
            CollectionUtil.fillList(list, n);
        }
    }

    private void adjustFlags() {
        int n;
        for (n = this.updatedRows.size(); n < this.getRowCount(); ++n) {
            this.updatedRows.add(new Boolean(false));
        }
        for (n = this.deletedRows.size(); n < this.getRowCount(); ++n) {
            this.deletedRows.add(new Boolean(false));
        }
        for (n = this.insertedRows.size(); n < this.getRowCount(); ++n) {
            this.insertedRows.add(new Boolean(false));
        }
    }

    private void adjustInsertRow() {
        this.insertRow = this.createCaseAwareMap();
        Iterator iterator = this.columnMap.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(null);
            this.insertRow.put((String)iterator.next(), arrayList);
        }
    }

    private void copyColumnMap() {
        this.columnMapCopy = this.copyColumnDataMap(this.columnMap);
    }

    private String determineValidColumnName() {
        String string = "Column";
        int n = this.columnNameList.size() + 1;
        while (this.columnMap.containsKey(string + n)) {
            ++n;
        }
        return string + n;
    }

    private Map copyColumnDataMap(Map map) {
        Map map2 = this.createCaseAwareMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            for (int i = 0; i < list.size(); ++i) {
                Object object = ParameterUtil.copyParameter(list.get(i));
                arrayList.add(object);
            }
            map2.put(string, arrayList);
        }
        return map2;
    }

    private Map createCaseAwareMap() {
        return new CaseAwareMap(this.columnsCaseSensitive);
    }

    private NClob getNClobFromClob(Clob clob) throws SQLException {
        return new MockNClob(clob.getSubString(1L, (int)clob.length()));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ResultSet " + this.id + ":\n");
        stringBuffer.append("Number of rows: " + this.getRowCount() + "\n");
        stringBuffer.append("Number of columns: " + this.getColumnCount() + "\n");
        stringBuffer.append("Column names:\n");
        StringUtil.appendObjectsAsString(stringBuffer, this.columnNameList);
        stringBuffer.append("Data:\n");
        for (int i = 1; i <= this.getRowCount(); ++i) {
            stringBuffer.append("Row number " + i + ":\n");
            StringUtil.appendObjectsAsString(stringBuffer, this.getRow(i));
        }
        return stringBuffer.toString();
    }
}

