/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.jdbc.ResultSetFactory;
import com.mockrunner.jdbc.StringValuesTable;
import com.mockrunner.mock.jdbc.MockResultSet;

public class ArrayResultSetFactory
implements ResultSetFactory {
    private String[] columnNames = new String[0];
    private String[][] stringMatrix = new String[0][0];

    public ArrayResultSetFactory(StringValuesTable stringValuesTable) {
        if (stringValuesTable != null) {
            this.stringMatrix = stringValuesTable.getStringMatrix();
            this.columnNames = stringValuesTable.getColumnNames();
            return;
        }
        throw new IllegalArgumentException("the string table cannot be null");
    }

    public ArrayResultSetFactory(String[][] stringArray) {
        this.stringMatrix = StringValuesTable.verifyStringMatrix(stringArray);
    }

    public ArrayResultSetFactory(String[] stringArray, String[][] stringArray2) {
        this.stringMatrix = StringValuesTable.verifyStringMatrix(stringArray2);
        if (stringArray != null) {
            this.columnNames = StringValuesTable.verifyColumnNames(stringArray, stringArray2);
        }
    }

    @Override
    public MockResultSet create(String string) {
        if (string != null) {
            int n;
            MockResultSet mockResultSet = new MockResultSet(string);
            if (this.columnNames != null) {
                for (n = 0; n < this.columnNames.length; ++n) {
                    mockResultSet.addColumn(this.columnNames[n]);
                }
            }
            for (n = 0; n < this.stringMatrix.length; ++n) {
                mockResultSet.addRow(this.stringMatrix[n]);
            }
            return mockResultSet;
        }
        throw new IllegalArgumentException("the result set ID cannot be null");
    }
}

