////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) Microsoft Corporation.  All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////#include <tinyhal.h>

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _PLATFORM_RX62N_ULTM_SELECTOR_H_
#define _PLATFORM_RX62N_ULTM_SELECTOR_H_ 1

/////////////////////////////////////////////////////////
//
// processor and features
//
#if defined(PLATFORM_RX62N_ULTM)
#define HAL_SYSTEM_NAME                    "RX62N_ULTM"

#define PLATFORM_RX600                      1
#define PLATFORM_RX62N                      1

#define USB_ALLOW_CONFIGURATION_OVERRIDE    1

//--//


// processor and features
//
/////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////
//
// constants
//
#define PLATFORM_SUPPORTS_SOFT_REBOOT   TRUE

#define SYSTEM_CLOCK_HZ                 96000000
#define CLOCK_COMMON_FACTOR             1
#define SLOW_CLOCKS_PER_SECOND          48000000
#define SLOW_CLOCKS_TEN_MHZ_GCD         1
#define SLOW_CLOCKS_MILLISECOND_GCD     1000

#define SRAM1_MEMORY_Base   0x08000000
#define SRAM1_MEMORY_Size   0x01000000

#define FLASH_MEMORY_Base   0xFFF80000
#define FLASH_MEMORY_Size   0x00080000

#define TXPROTECTRESISTOR               RESISTOR_DISABLED
#define RXPROTECTRESISTOR               RESISTOR_DISABLED
#define CTSPROTECTRESISTOR              RESISTOR_DISABLED
#define RTSPROTECTRESISTOR              RESISTOR_DISABLED


#define DRIVER_PAL_BUTTON_MAPPING               \
    { GPIO_PIN_NONE, BUTTON_B0 }, /* Up */      \
    { GPIO_PIN_NONE, BUTTON_B1 }, /* Down */    \
    { GPIO_PIN_NONE, BUTTON_B2 }, /* Left */    \
    { GPIO_PIN_NONE, BUTTON_B3 }, /* Right */   \
    { GPIO_PIN_NONE, BUTTON_B4 }, /* Enter */   \
    { GPIO_PIN_NONE, BUTTON_B5 }, /* User */

#define INSTRUMENTATION_H_GPIO_PIN      GPIO_PIN_NONE

#if 1
    #define DEBUG_TEXT_PORT         COM3
    #define STDIO                   COM3
    #define DEBUGGER_PORT           COM3
    #define MESSAGING_PORT          COM3
#else
    #define DEBUG_TEXT_PORT         USB1
    #define STDIO                   USB1
    #define DEBUGGER_PORT           USB1
    #define MESSAGING_PORT          USB1
#endif
//
//
// constants
/////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  SOCKETS ENABLED PLATFORM -- TODO TODO TODO: REMOVE WHEN PLATFORM BUILDER AVAILABLE
//
//Network SOCKET

#define NETWORK_INTERFACE_COUNT             1

#define PLATFORM_DEPENDENT__SOCKETS_MAX_SEND_LENGTH 8192

#define NETWORK_MEMORY_PROFILE__medium      1

#define NETWORK_MEMORY_POOL__INCLUDE_SSL    1

#ifdef TCPIP_LWIP
#include <pal\net\Network_Defines_LWIP.h>
#else
#include <pal\net\Network_Defines.h>
#endif

//#define NETWORK_USE_LOOPBACK                1
//#define NETWORK_USE_DHCP                    1

//--//

#define PLATFORM_DEPENDENT__NETWORK_DNS_MIN_DELAY  4 
#define PLATFORM_DEPENDENT__NETWORK_DNS_MAX_DELAY  32
#define PLATFORM_DEPENDENT__NETWORK_DNS_RETRIES    3

//Network SOCKET


// LCD index Memory mapping address
// RX62N LCD Memory Map
#define PF_INDEX_REG  0x18000000
#define PF_DATA_REG   0x1A000000



#include <processor_selector.h>

#endif // PLATFORM_RX62N_ULTM
//
// drivers
/////////////////////////////////////////////////////////

#endif // _PLATFORM_RX62N_ULTM_SELECTOR_H_ 1
