using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;

namespace CreateSymdef
{
	class Program
	{
		static void Main(string[] args)
		{
			if (args.Length == 0)
			{
				PrintUsage();
			}
			else
			{
				String inFileName = args[0];
				String outFileName;

				if (args.Length < 2)
				{
					outFileName = inFileName + ".symdefs";
				}
				else
				{
					outFileName = args[1];
				}

				Regex re = new Regex("^  ([A-Za-z_].*)\n +([0-9a-f]+) +([0-9a-f]+) +(data |func |none |entry),(g|l) +([0-9a-f]+)");

				using (StreamReader reader = new StreamReader(inFileName))
				using (StreamWriter writer = new StreamWriter(outFileName, false))
				{
					String line1, line2 = "", line;

					do
					{
						line1 = line2;
						line2 = reader.ReadLine();
						line = line1 + "\n" + line2;

						Match m = re.Match(line);
						if (m.Success)
						{
							writer.WriteLine("0x" + m.Groups[2].Value + " A " + m.Groups[1].Value);
						}
					} while (reader.EndOfStream == false);
				}

				Console.WriteLine("Done !");
			}
		}

		static void PrintUsage()
		{
			Console.WriteLine("");
			Console.WriteLine("Wrong Arguments");
			Console.WriteLine("");
			Console.WriteLine("CreateSymdef - ADENEO 2008");
			Console.WriteLine("Convert a gcc dump file (generated with 'nm') to an ARM Symdefs compliant file");
			Console.WriteLine("USAGE :");
			Console.WriteLine("\tCreateSymdef <dump file> <symdef file>");

		}
	}
}
