/*
 *    Copyright (C) 2010 Renesas Electronics America Inc. All rights reserved.
 */

#include <tinyhal.h>
#include "RSPI.h"
#include "..\iodefine.h"


void RSPI_Driver::Protect_Ctrl(unsigned char    proctect_flag)
{
    if( proctect_flag == 0 )
        Write_Status(UNPROTECT_STATUS);     
    else
        Write_Status(PROTECT_STATUS);   
}

void RSPI_Driver::Chip_ID(unsigned char * id)
{
    unsigned char cmd[1];
    cmd[0] = SFLASH_READ_ID;

    Receive_Exe(cmd, 1, id, 3);
}


void RSPI_Driver::Sector_Erase(unsigned long addr)
{
    unsigned char cmd[4];
    //unsigned int addr = sector_num * 0x10000;
    
    cmd[0] = SFLASH_SECTOR_ERASE;
    cmd[1] = (addr >> 16) & 0xff;
    cmd[2] = (addr >>  8) & 0xff;
    cmd[3] =  addr        & 0xff;

    Write_Enable();
    Transmit_Exe(cmd, 4, NULL, 0);
    Busy_Wait();
    Write_Disable();
}

void RSPI_Driver::Byte_Program(unsigned int addr, unsigned char *buf, int size)
{
    unsigned char cmd[4];
    
    cmd[0] = SFLASH_BYTE_PROGRAM;
    cmd[1] = (unsigned char)((addr >> 16) & 0xff);
    cmd[2] = (unsigned char)((addr >>  8) & 0xff);
    cmd[3] = (unsigned char)( addr        & 0xff);
    
    Write_Enable();
    
    Transmit_Exe(cmd, 4, buf, size);
    Busy_Wait();
    Write_Disable();
}

void RSPI_Driver::Byte_Read(unsigned int addr, unsigned char *buf, int size)
{
    unsigned char cmd[4];
    
    cmd[0] = SFLASH_BYTE_READ;
    cmd[1] = (unsigned char)((addr >> 16) & 0xff);
    cmd[2] = (unsigned char)((addr >>  8) & 0xff);
    cmd[3] = (unsigned char)( addr        & 0xff);
    
    Receive_Exe(cmd, 4, buf, size);
}

void RSPI_Driver::Write_Enable()
{
    unsigned char cmd[1];
    
    cmd[0] = SFLASH_WRITE_ENABLE;
    
    Transmit_Exe(cmd, 1, NULL, 0);
}

void RSPI_Driver::Write_Disable()
{
    unsigned char cmd[1];
    
    cmd[0] = SFLASH_WRITE_DISABLE;
    
    Transmit_Exe(cmd, 1, NULL, 0);
}

void RSPI_Driver::Busy_Wait()
{
    while ((Read_Status() & 0x01) != 0) {   /* RDY/BSY */
    }
}

unsigned char RSPI_Driver::Read_Status()
{
    unsigned char buf;
    unsigned char cmd[1];

    cmd[0] = SFLASH_READ_STATUS;
    
    Receive_Exe(cmd, 1, &buf, 1);
    
    return buf;
}

void RSPI_Driver::Write_Status(unsigned char status)
{
    unsigned char cmd[2];

    cmd[0] = SFLASH_WRITE_STATUS;
    cmd[1] = status;    

    Write_Enable(); 
    Transmit_Exe(cmd, 2, NULL, 0);
    Busy_Wait();
    Write_Disable();
}

void RSPI_Driver::RSPI_Initialize()
{
	// RSPIB-A
	SYSTEM.MSTPCRB.BIT.MSTPB16 = 0;
	IOPORT.PFHSPI.BYTE = 0x0e;
	PORT3.DDR.BIT.B0 = 0;
	PORT3.ICR.BIT.B0 = 1;
	PORT3.DDR.BIT.B1 = 1;
	PORT3.DR.BIT.B1 = 1;

    RSPI1.SPCR.BYTE   = 0x00;
    RSPI1.SPPCR.BYTE  = 0x30;
    RSPI1.SPBR.BYTE   = 0x01;
    RSPI1.SPDCR.BYTE  = 0x20;

    RSPI1.SPCKD.BYTE  = 0x00;
    RSPI1.SSLND.BYTE  = 0x00;
    RSPI1.SPND.BYTE   = 0x00;
    RSPI1.SPSCR.BYTE  = 0x00;
    RSPI1.SPCMD0.WORD = 0xE780;

    //RSPI1.SPBFCR.BYTE = 0xC0;
    //RSPI1.SPBFCR.BYTE = 0x00;

    RSPI1.SSLP.BYTE   = 0x00;
    RSPI1.SPCR.BYTE   = 0x48;
}

void RSPI_Driver::Transmit_Exe(unsigned char *cmd, int cmd_size, unsigned char *buff, int buff_size)
{
    unsigned char data;
    unsigned char tmp;                  
    short total_bytes = cmd_size + buff_size;           

	PORT3.DR.BYTE	&= ~(1 << 1);

	RSPI1.SPCMD0.BIT.SSLKP = 1;

    while(1)
    {
        if( cmd_size > 0 )
        {
            data = *cmd++;
            cmd_size--;
        }
        else
            data = *buff++;
        
        if(total_bytes > 1)
        {   
            Byte_Transfer(data, &tmp, 1);
            total_bytes--;
        }
        else
            break;
    }
    Wait_TX_End();                  
    RSPI1.SPCMD0.BIT.SSLKP = 0; 

    Byte_Transfer(data, &tmp ,1);

	PORT3.DR.BYTE	|= (1 << 1);
}

void RSPI_Driver::Receive_Exe(unsigned char *cmd, int cmd_size, unsigned char *buff, int buff_size)
{
    unsigned char tmp;

	PORT3.DR.BYTE	&= ~(1 << 1);

    RSPI1.SPCMD0.BIT.SSLKP = 1;

    while( cmd_size-- > 0)
        Byte_Transfer(*cmd++, &tmp, 1);

    while( buff_size-- > 1)
        Byte_Transfer(0, buff++, 0);

    Wait_TX_End();                  
    RSPI1.SPCMD0.BIT.SSLKP = 0;         
    Byte_Transfer(0, buff, 0);

	PORT3.DR.BYTE	|= (1 << 1);
}

void RSPI_Driver::Byte_Transfer(unsigned char tx, unsigned char *rx, unsigned char transfer_flag)
{
    while(RSPI1.SPSR.BIT.SPTEF == 0);

    RSPI1.SPDR.LONG = tx;

    while (RSPI1.SPSR.BIT.SPRF == 0);
    
    *rx = RSPI1.SPDR.LONG;
}

void RSPI_Driver::Wait_TX_End()
{
    while(RSPI1.SPSR.BIT.SPTEF == 0);    
}
