////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) Microsoft Corporation.  All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////#include <tinyhal.h>

/*
 *    Copyright (C) 2009-2010 Renesas Electronics America Inc. All rights reserved.
 */
 
#include <tinyhal.h>
#include <Tests.h>
#include "nativesample.h"

//--//

extern void  Network_Interface_Process_Packet();
extern int   Network_Interface_ARP_Request(unsigned long dest_ip);
extern BOOL  Network_Interface_ARP_Ack();
extern BOOL  Network_Interface_ICMP_Echo(unsigned long dest_ip);
extern BOOL  Network_Interface_ICMP_Ack();
extern void  Network_Interface_IP_Address();
extern void  Network_Interface_EtherC_Registers();
extern void  Network_Interface_EDMAC_Registers();

#ifdef TCPIP_LWIP 
void  Network_PostEvent(UINT32 evt, UINT32 data)
{
}
#endif

extern struct BlockStorageDevice  g_INTERNALFLASH;
extern struct IBlockStorageDevice g_RX62N_INTERNAL_FLASH_DeviceTable;
extern struct BLOCK_CONFIG        g_INTERNALFLASH_Config;

BlockStorageDevice  * pBlockStorageDevice = &g_INTERNALFLASH;
BLOCK_CONFIG        * pBLOCK_CONFIG         = &g_INTERNALFLASH_Config;

extern struct BlockStorageDevice  g_SerialFlash_Device;
extern struct IBlockStorageDevice g_SerialFlash_BL_DeviceTable;
extern struct BLOCK_CONFIG        g_SerialFlash_BL_Config;

BlockStorageDevice  * pBlockStorageDevice_SERIAL    = &g_SerialFlash_Device;
BLOCK_CONFIG        * pBLOCK_CONFIG_SERIAL          = &g_SerialFlash_BL_Config;

HAL_DECLARE_NULL_HEAP();

void ApplicationEntryPoint()
{
    char Data[1], previousChar = '\0';
    int ret = 0, TestItem = 0;
    BOOL validCommand = TRUE;
	
	MEMORY_MAPPED_NOR_BLOCK_CONFIG* config;
	
//    BlockStorageDevice *device;
//    ByteAddress datByteAddress;

//    BlockStorageList::FindDeviceForPhysicalAddress( &device, 0, datByteAddress );
//    const BlockDeviceInfo * deviceInfo=device->GetDeviceInfo();


    
    Data[1] = '\0';
    char ip[15];
    int length;
    unsigned long dest_ip=0;
    UINT32 sleep = 100;

//    TimedEvents eventsTest;
 //   UART        usartTest  ( COMTestPort, 9600, USART_PARITY_NONE, 8, USART_STOP_BITS_ONE, USART_FLOW_NONE );
//    GPIO        gpioTest   ( GPIOTestPin );

    do
    {
        lcd_printf( "\n\n\n\n\n\n\n\n   ULTIMATE RX62N\n" );
        lcd_printf( " Renesas America       Inc." );
                
        //Serial TEST
        hal_printf( "\r\nULTIMATE RX62N .NET Micro Framework NativeSample\r\n" );
        hal_printf( "Renesas Electronics America Inc.\r\n" );
        hal_printf( "96 MHz Clk,little-endian\r\n" );      
        hal_printf( ">" );
        
        NATIVE_PROFILE_PAL_EVENTS();
        do
        {
            UINT32 Events = Events_WaitForEvents( SYSTEM_EVENT_FLAG_COM_IN | SYSTEM_EVENT_FLAG_ETHER, sleep );

            // if(Events == 0)
            // {
                // hal_printf("Slept %d sec\r\n", sleep / 1000);
                // sleep += 1000; 
                // continue;
            // }
            
            if(Events & SYSTEM_EVENT_FLAG_ETHER)            
            {
                //Network_Interface_Process_Packet();
				//hal_printf("ETHER event\r\n");
                Events_Clear( SYSTEM_EVENT_FLAG_ETHER );
            }
                        
            if(Events & SYSTEM_EVENT_FLAG_COM_IN)           
            {
                Events_Clear( SYSTEM_EVENT_FLAG_COM_IN );
                while((ret = DebuggerPort_Read( HalSystemConfig.DebugTextPort, Data, 1 )) > 0)
                {                   
                    switch(TestItem)
                    {
                        case 0:     //None
                            if(Data[0] == 0xD)              //0xD: ENTER key
                            {                               
                                hal_printf( "\r\n" );
                                if(validCommand)
                                {
                                    TestItem = 1;           //Enter test
                                    validCommand = FALSE;
                                    previousChar = '\0';
                                    hal_printf( "\r\nTest Menu:\r\n" );
                                    hal_printf( "   [L]CD Tests\r\n" );
                                    hal_printf( "   [K]eypad Tests\r\n" );
                                    hal_printf( "   [N]etwork Tests\r\n" );
                                    hal_printf( "   [F]lash memory Tests\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                }
                                else if(previousChar == 'I')
                                {
                                    hal_printf("** Invalid Selection\r\n>");
                                    previousChar = '\0';
                                }
                                else
                                    hal_printf( ">" );
                            }
                            else
                            {
                                hal_printf( Data );
                                if(Data[0] == 'd' || Data[0] == 'D')
                                {
                                    if(previousChar == '\0')
                                        previousChar = 'd';
                                    else
                                    {
                                        validCommand = FALSE;
                                        previousChar = 'I';     //Invalid character input
                                    }
                                }
                                else if(Data[0] == 't' || Data[0] == 'T')
                                {
                                    if(previousChar == 'd')
                                    {
                                        previousChar = 't';
                                        validCommand = TRUE;
                                    }
                                    else
                                    {
                                        validCommand = FALSE;
                                        previousChar = 'I';     //Invalid character input
                                    }
                                }
                                else
                                {
                                    validCommand = FALSE;
                                    previousChar = 'I';         //Invalid character input
                                }
                            }
                            break;
                        case 1:     //Enter test
                            hal_printf( Data );
                            switch(Data[0])
                            {
                                case 'X':
                                case 'x':
                                    TestItem = 0;
                                    hal_printf( "\r\n\n>" );
                                    break;
                                case 'L':
                                case 'l':
                                    TestItem = 5;
                                    hal_printf( "\r\n\nLCD Menu:\r\n" );
                                    hal_printf( "   1: Display colorful rectangles\r\n" );
                                    hal_printf( "   2: Colorful wireframe rectangle\r\n" );
                                    hal_printf( "   3: Colorful solid rectangle\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case 'N':
                                case 'n':
                                    TestItem = 7;
                                    hal_printf( "\r\n\nEthernet Menu:\r\n" );
                                    hal_printf( "   [1]Read IP Address\r\n" );
                                    hal_printf( "   [2]Read EtherC Registers\r\n" );
                                    hal_printf( "   [3]Read E-DMAC Registers\r\n" );
                                    hal_printf( "   [4]Ping Test\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;                              
                                case 'F':
                                case 'f':
                                    TestItem = 8;
                                    hal_printf( "\r\n\nFlash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block\r\n" );
                                    hal_printf( "   [2]write block\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;                              
                                default:
                                    hal_printf( "\r\n\nTest Menu:\r\n" );
                                    hal_printf( "   [L]CD Tests\r\n" );
                                    hal_printf( "   [K]eypad Tests\r\n" );
                                    hal_printf( "   [N]etwork Tests\r\n" );
                                    hal_printf( "   [F]lash memory Tests\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                            }
                            break;
                        case 7:     //Ethernet test
                            hal_printf( Data );
                            hal_printf( "\r\n" );
                            switch(Data[0])
                            {
                                case 'X':
                                case 'x':
                                    TestItem = 1;
                                    hal_printf( "\r\n\nTest Menu:\r\n" );
                                    hal_printf( "   [L]CD Tests\r\n" );
                                    hal_printf( "   [K]eypad Tests\r\n" );
                                    hal_printf( "   [N]etwork Tests\r\n" );
                                    hal_printf( "   [F]lash memory Tests\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '1':
                                    //Network_Interface_IP_Address();                                 
                                    hal_printf( "\r\n\nEthernet Menu:\r\n" );
                                    hal_printf( "   [1]Read IP Address\r\n" );
                                    hal_printf( "   [2]Read EtherC Registers\r\n" );
                                    hal_printf( "   [3]Read E-DMAC Registers\r\n" );
                                    hal_printf( "   [4]Ping Test\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '2':
                                    //Network_Interface_EtherC_Registers();
                                    hal_printf( "\r\n\nEthernet Menu:\r\n" );
                                    hal_printf( "   [1]Read IP Address\r\n" );
                                    hal_printf( "   [2]Read EtherC Registers\r\n" );
                                    hal_printf( "   [3]Read E-DMAC Registers\r\n" );
                                    hal_printf( "   [4]Ping Test\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '3':
                                    //Network_Interface_EDMAC_Registers();
                                    hal_printf( "\r\n\nEthernet Menu:\r\n" );
                                    hal_printf( "   [1]Read IP Address\r\n" );
                                    hal_printf( "   [2]Read EtherC Registers\r\n" );
                                    hal_printf( "   [3]Read E-DMAC Registers\r\n" );
                                    hal_printf( "   [4]Ping Test\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;                              
                                case '4':
                                    //do
                                    //{
                                    //    hal_printf( "\r\nEnter dest IP: " );
                                    //    Get_IP_String(ip, &length);
                                    //    if( (dest_ip = Is_IP_Address(ip, length)) == 0)
                                    //        hal_printf( "\r\n*** Invalid IP Address!\r\n" );
                                    //}while(dest_ip == 0);
                                    //Ether_Ping(dest_ip, 4); 
                                    hal_printf( "\r\n\nEthernet Menu:\r\n" );
                                    hal_printf( "   [1]Read IP Address\r\n" );
                                    hal_printf( "   [2]Read EtherC Registers\r\n" );
                                    hal_printf( "   [3]Read E-DMAC Registers\r\n" );
                                    hal_printf( "   [4]Ping Test\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;                          
                                default:
                                    hal_printf( "\r\n\nEthernet Menu:\r\n" );
                                    hal_printf( "   [1]Read IP Address\r\n" );
                                    hal_printf( "   [2]Read EtherC Registers\r\n" );
                                    hal_printf( "   [3]Read E-DMAC Registers\r\n" );
                                    hal_printf( "   [4]Ping Test\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                            }
                            break;
                        case 8:     //Flash memory test
                            hal_printf( Data );
                            hal_printf( "\r\n" );
                            switch(Data[0])
                            {
                                case 'X':
                                case 'x':
                                    TestItem = 1;
                                    hal_printf( "\r\n\nTest Menu:\r\n" );
                                    hal_printf( "   [L]CD Tests\r\n" );
                                    hal_printf( "   [K]eypad Tests\r\n" );
                                    hal_printf( "   [N]etwork Tests\r\n" );
                                    hal_printf( "   [F]lash memory Tests\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '1':
									g_RX62N_INTERNAL_FLASH_DeviceTable.InitializeDevice(pBLOCK_CONFIG);
									g_RX62N_INTERNAL_FLASH_DeviceTable.EraseBlock(pBLOCK_CONFIG,0xa0080000);
                                    hal_printf( "\r\n\nFlash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block\r\n" );
                                    hal_printf( "   [2]write block\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '2':
									BYTE Buff[0x10];
									for(int i=0; i<0x10; i++) Buff[i]=i;
									g_RX62N_INTERNAL_FLASH_DeviceTable.InitializeDevice(pBLOCK_CONFIG);
									g_RX62N_INTERNAL_FLASH_DeviceTable.Write(pBLOCK_CONFIG,0xa0080000,0x10,Buff,0x0);
                                    hal_printf( "\r\n\nFlash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block\r\n" );
                                    hal_printf( "   [2]write block\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                default:
                                    hal_printf( "\r\n\nFlash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block\r\n" );
                                    hal_printf( "   [2]write block\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                            }
                            break;
                        //Added Serial Flash memory test
                        case 9:     
                            hal_printf( Data );
                            hal_printf( "\r\n" );
                            switch(Data[0])
                            {
                                case 'X':
                                case 'x':
                                    TestItem = 1;
                                    hal_printf( "\r\nTest Menu:\r\n" );
                                    hal_printf( "   [V]DC3 Tests\r\n" );
                                    hal_printf( "   [K]eypad Tests\r\n" );
                                    hal_printf( "   [U]SB Flash Tests\r\n" );
                                    hal_printf( "   [S]erial flash memory Tests\r\n" );
                                    hal_printf( "   [N]or flash memory Tests\r\n" );  //Added Nor flash memory test                                 
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '1':
                                    g_SerialFlash_BL_DeviceTable.InitializeDevice(pBLOCK_CONFIG_SERIAL);
                                    g_SerialFlash_BL_DeviceTable.EraseBlock(pBLOCK_CONFIG_SERIAL,0xF0000);
                                    hal_printf( "\r\n\nSerial Flash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block (Address 0xF0000)\r\n" );
                                    hal_printf( "   [2]Write block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   [3]Read block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '2':
                                    BYTE Buff[0x10];
                                    for(int i=0; i<0x10; i++) Buff[i]=i;
                                    g_SerialFlash_BL_DeviceTable.InitializeDevice(pBLOCK_CONFIG_SERIAL);
                                    g_SerialFlash_BL_DeviceTable.Write(pBLOCK_CONFIG_SERIAL,0xF0000,0x10,Buff,0x0);
                                    hal_printf( "\r\n\nSerial Flash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block (Address 0xF0000)\r\n" );
                                    hal_printf( "   [2]Write block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   [3]Read block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                case '3':
                                    BYTE rBuff[0x10];                                   
                                    g_SerialFlash_BL_DeviceTable.InitializeDevice(pBLOCK_CONFIG_SERIAL);
                                    g_SerialFlash_BL_DeviceTable.Read(pBLOCK_CONFIG_SERIAL,0xF0000,0x10,rBuff);
                                    hal_printf( "Read Data =" );
                                    for(int i=0; i<0x10; i++) hal_printf( " 0x%02x", rBuff[i] );
                                    hal_printf( "\r\n" );
                                    hal_printf( "\r\n\nSerial Flash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block (Address 0xF0000)\r\n" );
                                    hal_printf( "   [2]Write block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   [3]Read block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                                default:
                                    hal_printf( "\r\n\nSerial Flash memory Menu:\r\n" );
                                    hal_printf( "   [1]Erase block (Address 0xF0000)\r\n" );
                                    hal_printf( "   [2]Write block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   [3]Read block (Address 0xF0000 to 0xF000F)\r\n" );
                                    hal_printf( "   E[x]it\r\n" );
                                    hal_printf( "Your choice: " );
                                    break;
                            }
                            break;
                    }
                }
            }           
        } while(TRUE);
    } while(FALSE); // run only once!
}
