#ifndef CRYPT64_H__
#define CRYPT64_H__

#include "config.h"

#define N_I			(sizeof(WS_T) / sizeof(uint32_t))
#define N_Q			(sizeof(WS_T) / sizeof(uint64_t))
#define N_ALU		(sizeof(WS_T) / sizeof(ALU_T))

/* 1rbg */
typedef union SLICE
{
  uint32_t	i[N_I];		/* 32-bit initializer */
  ALU_T		a[N_ALU];	/* C ň₷TCY */
  uint64_t	q[N_Q];		/* 64-bit for transpose */
  WS_T		w;			/* GR[hňTCY */
} SLICE;

/* crypt64() 򂤃p[^ */
struct PARAM
{
  SLICE lr[2][32];
  SLICE t[0x1000];	/* 32 ȏ */
};

/* Srbg1 */
#define T_INV		16

/* LR ƁÃRs[Kv
   KEY::k[0]			LR
   KEY::k[1]			LR̃Rs[(]Ȃ)
   KEY::k[2][0][i].a[0]	ւ̑ */
struct KEY
{
  SLICE k[2][2][28];
  SLICE ks[28];
};

extern short los[];
extern signed char crypt64_sta[];
extern signed char loo[];
extern signed char crypt64_ep[];
extern signed char crypt64_ep_end[];
extern signed char crypt64_end[];

#ifdef USE_REGPARM

/* REGPARM ́AA, D, C ̏ł
   Ă΂ꑤ MSFASTCALL(C, D) OȂ̂ŁAA ɂ̓_~[lB */
typedef int32_t __attribute__((regparm(3)))
	 (*CRYPT64_PP_T)(void *a, SLICE (*lr)[32], SLICE (*k)[2][28]);
#define CALL_CRYPT64(code,k,lr) (*(CRYPT64_PP_T)(code))(code, lr, k)

#else /* USE_REGPARM */

typedef int32_t (__fastcall *CRYPT64_PP_T)(SLICE (*k)[2][28], SLICE (*lr)[32]);
#define CALL_CRYPT64(code,k,lr) (*(CRYPT64_PP_T)(code))(k, lr)

#endif /* USE_REGPARM */

#endif /* CRYPT64_H__ */

/*
 *	Local Variables:
 *		tab-width:	4
 *	End:
 *
 * EOF */
