/**********************************************************-*-verilog-*-
 *
 *	DES x 2i (latency=4)
 *	$Id: des24.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module des24(i_l, i_r, i_fk, i_k,
			 l, r, k,
			 clk5, salt, kp);

	input [1:32] 	i_l;
	input [1:32] 	i_r;
	input [55:0] 	i_fk;
	input [55:0] 	i_k;

	output [1:32] 	l;
	output [1:32] 	r;
	output [55:0] 	k;

	input			clk5;
	input [11:0] 	salt;
	input [55:0] 	kp;	// phase cache

	parameter		kmsk = 56'b0000_0000_1111_1111_111_111_111_111_000_000_000_000_000_000_000_000_0000;
	parameter		f_ram = 8'b1111_1111;
	parameter 		krna = 1;
	parameter 		krnb = krna + 2;

`include "conf.v"
`include "func_des.v"
`include "func_salt.v"

	wire [27:0] 	i_kl, i_kr;
	wire [1:48] 	ea, eb;
	wire [1:32] 	lna, lnb;

	reg [1:32] 		lna1, lnb1;
	reg [1:32] 		ra1, ra2, rb1, rb2;
	reg [55:0] 		ka1, ka2, kb1, kb2;

	wire [1:32] 	qa1, qa4, qb1, qb4;

	// phase cache
	wire [27:0] 	kp1, kp0;
	assign 			{kp1, kp0} = kp;

	/****************************************************************
	 *
	 *	Stage A
	 *
	 */

	assign 			{i_kr, i_kl} = kmux(kmsk, i_fk, i_k);
	assign 			ea = add_salt(salt, tr_e(i_r)) ^ {tr_pc2l(roln(pc1_l(i_kl), krna)),
													  tr_pc2r(roln(pc1_r(i_kr), krna))};
	assign 			lna = ir_p(i_l);

	// pCvCi߂
	always @(posedge clk5)
	begin
		lna1 <= lna;
		ra1 <= i_r;
		ra2 <= ra1;
		ka1 <= {i_kr, i_kl};
		ka2 <= ka1;
		//ka2 <= wh01k(kra1);
	end

	// A-B Ԍ
	wire [27:0]		klb, krb;
	wire [55:0] 	kb;
	wire [1:32] 	lb, rb;
	assign 			kb = ka2;
	assign			lb = ra2;
	assign 			rb = tr_p(rmuxq(f_ram, qa1, qa4));

	/****************************************************************
	 *
	 *	Stage B
	 *
	 */

	assign 			{krb, klb} = kmux(kmsk, i_fk, kb);
	assign 			eb = add_salt(salt, tr_e(rb)) ^ {tr_pc2l(roln(pc1_l(klb), krnb)),
													 tr_pc2r(roln(pc1_r(krb), krnb))};
	assign 			lnb = ir_p(lb);

	// pCvCi߂
	always @(posedge clk5)
	begin
		lnb1 <= lnb;
		rb1 <= rb;
		rb2 <= rb1;
		kb1 <= {krb, klb};
		kb2 <= kb1;
		//krb2 <= wh01k(krb1);
	end

	/***************************************************************
	 *
	 *	o͒i
	 *
	 */

	assign 			k = kb2;
	assign			l = rb2;
	assign 			r = tr_p(rmuxq(f_ram, qb1, qb4));

	/***************************************************************
	 *
	 *	ROMs
	 *
	 */
	// S1x1-S8x1 s߂ɕKv
	sbrom12 sb_a(clk5, ea, lna, lna1, qa1);
	sbrom12 sb_b(clk5, eb, lnb, lnb1, qb1);

	// 2iC!
	sbrom24 sb_ab(clk5,
				  ea, eb, lna, lnb,
				  qa4, qb4);

	/***************************************************************
	 *
	 *	o͂̐U蕪
	 *
	 */
	function [0:31] rmuxq;
		input [7:0] f;
		input [0:31] q1;
		input [0:31] q0;
		rmuxq = {f_ram[0] ? q1[ 0: 3] : q0[ 0: 3],
				 f_ram[1] ? q1[ 4: 7] : q0[ 4: 7],
				 f_ram[2] ? q1[ 8:11] : q0[ 8:11],
				 f_ram[3] ? q1[12:15] : q0[12:15],
				 f_ram[4] ? q1[16:19] : q0[16:19],
				 f_ram[5] ? q1[20:23] : q0[20:23],
				 f_ram[6] ? q1[24:27] : q0[24:27],
				 f_ram[7] ? q1[28:31] : q0[28:31]};
	endfunction

	/*
	 *	͂AphaseɉL[ĕԂ
	 *	k, kp  big endian ł邱ƂɒӁB
	 */
	function [27:0] wh01k;
		input [27:0] k;
		wh01k = k /*(k[kbn]
				 ? {kp1[27:kbn + 1], k[kbn:0]}
				 : {kp0[27:kbn + 1], k[kbn:0]})*/;
	endfunction

endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
