/**********************************************************-*-verilog-*-
 *
 *	a stage of DES - Xe[Wi
 *	$Id: des12.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module des12(i_l, i_r, i_fk, i_k,
			 l, r, k,
			 clk5, salt, kp);

	input [1:32] 	i_l;
	input [1:32] 	i_r;
	input [55:0] 	i_fk;
	input [55:0] 	i_k;

	output [1:32] 	l;
	output [1:32] 	r;
	output [55:0] 	k;

	input			clk5;
	input [11:0] 	salt;
	input [55:0] 	kp;	// phase cache

	parameter		kmsk = 56'b0000_0000_1111_1111_111_111_111_111_000_000_000_000_000_000_000_000_0000;
	parameter		f_ram = 8'b1111_1111;
	parameter 		krn = 1;

`include "conf.v"
`include "func_des.v"
`include "func_salt.v"

	// pCvCp
	wire [27:0] 	i_kl, i_kr;
	reg [1:32] 		ln1, ln2;	// ir_p Kpς
	reg [1:32]		r1, r2;
	reg [55:0] 		k1, k2;

	// phase cache
	wire [27:0] 	kp1, kp0;
	assign 			{kp1, kp0} = kp;

	/*
	 *	Fp
	 *	S1-S4͎ŒȂ̂
	 *	Eƍŏ
	 */
	wire [1:48] 	e;
	reg [1:48] 		e1, e2;
	reg [1:32] 		f;
	wire [1:32] 	ln;

	// ROM, RAM̏o
	wire [1:32] 	q;

	/***************************************************************
	 *
	 *	stage 1̑O
	 *	e ̈ꕔln̈ꕔ́ARAMɓnA
	 *	2NbNɌʂ𓾂B
	 */
	assign 			{i_kr, i_kl} = kmux(kmsk, i_fk, i_k);
	assign 			e = add_salt(salt, tr_e(i_r)) ^ {tr_pc2l(roln(pc1_l(i_kl), krn)),
													 tr_pc2r(roln(pc1_r(i_kr), krn))};
	assign 			ln = ir_p(i_l);	// for RAM

	/*
	 *	STAGE 1 (ƕsāARAMAb`s)
	 */
	always @(posedge clk5)
	begin
		k1 <= {i_kr, i_kl};
		ln1 <= ln;
		r1 <= i_r;
		e1 <= e;
	end

	/*
	 *  KvɉRAME
	 *	ŏIiXORZꕔ܂܂
	 */
	sbrom12 sb_a(clk5, e, ln, ln1, q);

	/*
	 *	STAGE 2 (hold with RAM Q)
	 *	RAMQ҂邩ALUT
	 *	key phase cache ɑ}邱ƂɂA
	 *	pCvCWX^̑啝ȍ팸}邱ƂłB
	 */
	always @(posedge clk5)
	begin
		//kr2 <= wh01k(kr1);
		k2 <= k1;
		r2 <= r1;
		ln2 <= ln1;
		f <= {s1(e1[ 1: 6]),
			  s2(e1[ 7:12]),
			  s3(e1[13:18]),
			  s4(e1[19:24]),
			  s5(e1[25:30]),
			  s6(e1[31:36]),
			  s7(e1[37:42]),
			  s8(e1[43:48])};
	end

	/*
	 *	(STAGE 3)
	 *	ŏIi̓b`Â܂܏o͂ɌqĂ
	 *	SynthesizerA̒i̓ƍœKĂ̂
	 *	҂邽߂łB
	 *
	 *	ݒɂĂ͂̎_ l2 ̓rbg}XN
	 *	邽߁A}XNꂽrbgXOR͍sȂ(nY)
	 */
	assign			l = r2;
	assign 			r = tr_p(rmuxq(f_ram, q, ln2 ^ f));	// gݍ킹̏o͂S
	assign 			k = k2;

	/***************************************************************
	 *
	 *	o͂̐U蕪
	 *
	 */
	function [0:31] rmuxq;
		input [7:0] f;
		input [0:31] q1;
		input [0:31] q0;
		rmuxq = {f_ram[0] ? q1[ 0: 3] : q0[ 0: 3],
				 f_ram[1] ? q1[ 4: 7] : q0[ 4: 7],
				 f_ram[2] ? q1[ 8:11] : q0[ 8:11],
				 f_ram[3] ? q1[12:15] : q0[12:15],
				 f_ram[4] ? q1[16:19] : q0[16:19],
				 f_ram[5] ? q1[20:23] : q0[20:23],
				 f_ram[6] ? q1[24:27] : q0[24:27],
				 f_ram[7] ? q1[28:31] : q0[28:31]};
	endfunction

	/*
	 *	͂AphaseɉL[ĕԂ
	 *	k, kp  big endian ł邱ƂɒӁB
	 */
	function [27:0] wh01k;
		input [27:0] k;
		wh01k = k /*(k[kbn]
				 ? {kp1[27:kbn + 1], k[kbn:0]}
				 : {kp0[27:kbn + 1], k[kbn:0]})*/;
	endfunction

endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
