/**********************************************************-*-verilog-*-
 *
 *	CRYPT(3)
 *	2ix2/25pCvC, latency=800
 *
 *	$Id: crypt22.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module crypt22(rst,
			   clk, clk5, st_gate,
			   ien, i_salt, i_k,
			   bsy,
			   oen, o_k, o_h);

	// VXe
	input			rst;		// HZbg
	input			clk;		// 32MHz O
	input 			clk5;		// 5{clk
	input 			st_gate;	// 5{gateM

	// (̃rbg͖)
	input 			ien;		// f[^Ƃage
	input [11:0] 	i_salt;		// ̂܂܉ʃW[
	input [55:0] 	i_k;		// ꕔ͂̂܂܉ʃW[

	// 
	output 			bsy;		// Ń[vĂƂ

	// o
	output 			oen;		// Ă鎞
	output [55:0] 	o_k;		// L[()
	output [1:64] 	o_h;		// o

	// KR 񂷂̂ɗLȋ
	parameter		krmsk = 28'b0000_0000_1111_1111_111_111_111_111;
	parameter 		klmsk = 28'b000_000_000_000_000_000_000_000_0000;

`include "conf.v"
`include "func_des.v"

	// for pipeline
	reg [27:0] 		kr;
	wire [27:0] 	mkr, kri;
	wire 			kr_end;		// ɂȂ痧
	assign 			mkr = kr | ~krmsk;
	assign 			{kr_end, kri} = mkr + 28'b1;

	wire [1:32] 	l0, l1, l01, l10;
	wire [1:32] 	r0, r1, r01, r10;
	wire [55:0] 	k0, k1, k01, k10;

	// phase cache
	reg [27:0] 		kp0, kp1;

	/*
	 *	Xe[g
	 *	bit11 ĂƂ́AKLZbgAbv
	 */
	reg 			bsy;
	reg [11:0] 		st;
	wire [11:0] 	sti;
	wire 			sti_of;
	assign 			{sti_of, sti} = st + 12'b1;

	// ߂Asbram 𕜊邱Ƃ邩Ȃ
	parameter 		KL_START		= 12'b1_000000_0_0000;

	// Xe[g
	parameter 		KL_FINISH_WAIT	= 12'b1_000000_0_0000;
	parameter 		KL_IDLE			= 12'b1_111111_1_1110;
	parameter 		KL_SETUP		= 12'b1_111111_1_1111;

	/*
	 *	Q[gɃANZX邽߂ɗp
	 *	registered ɂȂƁA傢ȂxyieB
	 */
	reg 			gate_filla, gate_fillb;
	reg 			gate_fetcha, gate_fetchb;

	// WX^(͂sv??)
	reg [27:0] 		kl;

	/*
	 *	Xe[g̃[v
	 */
	always @(posedge clk or posedge rst)
	  if (rst)
	  begin
		  bsy <= 0;
		  st <= KL_IDLE;
		  kl <= 28'b0;
		  kr <= 28'b0;
		  kp0 <= 28'b0;
		  kp1 <= 28'b0;
	  end
	  else
	  begin
		  /*
		   *	fill/fetch ̃Xe[g
		   *	kr CNg
		   */
		  if (gate_filla || gate_fillb)
		  begin
			  kr <= kri;

			  // phase cache ̃Abvf[g
			  if (&kr[kbn - 1:0])
			  begin
				  if (kr[kbn])
					kp0 <= kri;	// kr + 28'b100_0000_0000;
				  else
					kp1 <= kri; // kr + 28'b100_0000_0000;
			  end
		  end

		  // Xe[g
		  if (st == KL_SETUP)
		  begin
			  // 1EFCgĂ܂Agate ZbgAbv̂߂ɕKv
			  bsy <= 1;
			  st <= sti;
		  end
		  else if (st < 512)
		  begin
			  /*
			   *	fill/fetch ̃Xe[g
			   */
			  if (kr_end && (gate_filla || gate_fillb))
			  begin
				  st <= st + (1888 - 224 + 1);	// fetcĥ݃Xe[g
			  end
			  else if (st == 383)
				st <= 64;
			  else
				st <= sti;
		  end
		  else if (st < 2048)
		  begin
			  // fetch ݂̂̃Xe[g
			  if (sti == 2048)
			  begin
				  // RAM ̃ZbgAbvɓ
				  st <= KL_FINISH_WAIT;
				  bsy <= 0;
				  //kl <= i_pc1_l(rolk(pc1_l(kl + 1), 4'hF));
			  end

			  st <= sti;
		  end
		  else if (st == KL_FINISH_WAIT)
		  begin
			  // ÎŁA
			  // zXg ien ̂҂
			  // ̂ƂAbsy ͂Ă͂
			  if (!ien)
				st <= KL_IDLE;
		  end
		  else	// KL_IDLE ɂȂĂ
		  begin
			  if (ien)
			  begin
				  st <= KL_SETUP;	// XXX ꂾgate JȂ񂶂??
				  kr <= i_k[55:28] & ~krmsk;
				  bsy <= 1;
			  end
		  end
	  end

	/*
	 *	Q[g
	 *	{̓Xe[gɑ΂ăQ[g܂̂
	 *	^C~OIɊԂɍȂ̂ŁA
	 *	pre-increment  sti ŁAQ[g̊J߂
	 */
	always @(posedge clk or posedge rst)
	  if (rst)
	  begin
		  gate_filla <= 0;
		  gate_fillb <= 0;
		  gate_fetcha <= 0;
		  gate_fetchb <= 0;
	  end
	  else
	  begin
		  gate_filla <= (sti < 64
						 || (320 <= sti && sti < 384));
		  gate_fillb <= (160 <= sti && sti < 224);

		  // ł́AK fillb-fetchb łׂĂI
		  gate_fetcha <= (160 <= sti && sti < 224);
		  gate_fetchb <= ((320 <= sti && sti < 384)
						  || (1888 <= sti && sti < 2048));
	  end

	/*
	 *	pipline gate - fill
	 *	5Xe[WɐVK̃L[ł
	 */
	parameter	kmsk = {krmsk, klmsk};
	assign 		{l0, r0, k0} = (gate_filla && st_gate
								? {64'b0, kmux(kmsk, i_k, {kr, 28'b0})}
								: {l10, r10, kmux(kmsk, i_k, k10)});
	assign 		{l1, r1, k1} = (gate_fillb && st_gate
								? {64'b0, kmux(kmsk, i_k, {kr, 28'b0})}
								: {l01, r01, kmux(kmsk, i_k, k01)});

	/*
	 *	pipelines thru=1 lat=800(clk5), 160(clk)
	 *	25iׂf@CX́A_!
	 */
	(* ALTERA_ATTRIBUTE = "AUTO_PACKED_REGISTERS_STRATIX=NORMAL;STRATIX_OPTIMIZATION_TECHNIQUE=SPEED" *)
	des_pipeline #(kmsk) des1(clk5, l0, r0, i_k, k0, l01, r01, k01, i_salt, {kp1, kp0}, clk, 1'b0, 11'b0, 16'b0);
	(* ALTERA_ATTRIBUTE = "AUTO_PACKED_REGISTERS_STRATIX=NORMAL;STRATIX_OPTIMIZATION_TECHNIQUE=SPEED" *)
	des_pipeline #(kmsk) des2(clk5, l1, r1, i_k, k1, l10, r10, k10, i_salt, {kp1, kp0}, clk, 1'b0, 11'b0, 16'b0);

	// pCvC̏o͂荞
	assign 		oen = (gate_fetcha || gate_fetchb);
	assign 		o_k = kmux(kmsk, i_k, gate_fetcha ? k01 : k10);
	assign 		o_h = fp(gate_fetcha ? {l01, r01} : {l10, r10});

endmodule // crypt22

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
