/**********************************************************-*-verilog-*-
 *
 *	DESpSBox ROM 1i
 *	$Id: sbrom12.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module sbrom12(clk5,
			   e, ln0, ln1,
			   q);

	input			clk5;

	input [0:47] 	e;			// g]u̓͒l
	input [0:31] 	ln0, ln1;	// t]uL т1ix
	output [0:31] 	q;			// o

`include "func_des.v"

	// RAM ɋ킷AhXȂ
	wire [5:0] 		e1, e2, e3, e4, e5, e6, e7, e8;
	assign 			{e1, e2, e3, e4, e5, e6, e7, e8} = sae(e);

	wire [3:0] 		ln01, ln02, ln03, ln04, ln05, ln06, ln07, ln08;
	assign 			{ln01, ln02, ln03, ln04, ln05, ln06, ln07, ln08} = ln0;

	/*
	 *	S1-S8(x1) ROM (M512) o̓b`Ȃ
	 */
	wire [0:3] 		q1, q2, q3, q4, q5, q6, q7, q8;
	srom1x1 sb1({e1, ln01[3]}, clk5, q1);
	//exemplar attribute sb1 NOOPT TRUE
	srom2x1 sb2({e2, ln02[3]}, clk5, q2);
	//exemplar attribute sb2 NOOPT TRUE
	srom3x1 sb3({e3, ln03[3]}, clk5, q3);
	//exemplar attribute sb3 NOOPT TRUE
	srom4x1 sb4({e4, ln04[3]}, clk5, q4);
	//exemplar attribute sb4 NOOPT TRUE
	srom5x1 sb5({e5, ln05[3]}, clk5, q5);
	//exemplar attribute sb5 NOOPT TRUE
	srom6x1 sb6({e6, ln06[3]}, clk5, q6);
	//exemplar attribute sb6 NOOPT TRUE
	srom7x1 sb7({e7, ln07[3]}, clk5, q7);
	//exemplar attribute sb7 NOOPT TRUE
	srom8x1 sb8({e8, ln08[3]}, clk5, q8);
	//exemplar attribute sb8 NOOPT TRUE

	/*
	 *	o͌MUX
	 */
	reg [0:31] 		q;
	always @(posedge clk5)
	begin
		q <= ((ln1 & 32'b0111_0111_0111_0111_0111_0111_0111_0111)
			  ^ {q1, q2, q3, q4, q5, q6, q7, q8});
	end

endmodule

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
