#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "special.h"
#include "util.h"

#define TRIP_LEN 10

#define ST_ALLN 1      /* S */
#define ST_NIKO 1<<0x1 /* \ */
#define ST_BUOO 1<<0x8 /* Ԃ */
#define ST_DOSU 1<<0x9 /* { */
#define ST_CHIN 1<<0xb /*  */
#define ST_EROI 1<<0xc /* G */
#define ST_HREN 1<<0xd /* A */
#define ST_YAKU 1<<0xe /* _ */

int	special;

static FILE	*nfp;	/* S */
#define LOGNUM "lognum.txt"
static FILE	*cfp;	/*  */
#define LOGCHI "logchi.txt"
static FILE	*tfp;	/* ȊO̓ꌟ */
#define LOGSPE "logspe.txt"

void
dispSpecial()
{
  printf( "ꌟIvV : " );
  if ( special & ST_DOSU ) {
   printf( "{ " );
  } else {
   if ( special & ST_ALLN ) {
    printf( "S " );
   }
  }
  if ( special & ST_EROI ) {
   printf( "G " );
  }
  if ( special & ST_NIKO ) {
   printf( "\ " );
  }
  if ( special & ST_BUOO ) {
   printf( "Ԃ " );
  }
  if ( special & ST_CHIN ) {
   printf( " " );
  }
  if ( special & ST_HREN ) {
   printf( "A " );
  }
  if ( special & ST_YAKU ) {
   printf( "_ " );
  }
  if ( special ) {
   printf( "II\n" );
  } else {
   printf( "I[ItI\n" );
  }
}

void
initSpecial()
{
  special = 0;

  if ( (tfp = fopen( LOGSPE, "at" )) == NULL ) {
   perror( LOGSPE );
   exit( 1 );
  }
  setvbuf( tfp, NULL, _IONBF, BUFSIZ );

  if ( (nfp = fopen( LOGNUM, "at" )) == NULL ) {
   perror( LOGNUM );
   exit( 1 );
  }
  setvbuf( nfp, NULL, _IONBF, BUFSIZ );

  if ( (cfp = fopen( LOGCHI, "at" )) == NULL ) {
   perror( LOGCHI );
   exit( 1 );
  }
  setvbuf( cfp, NULL, _IONBF, BUFSIZ );
}

void
comment( str )
char	*str;
{
  if ( strlen( str ) >= 4 ) {
   if ( str[1] == '[' && str[3] == ']' ) {
    switch ( str[2] ) {
     case '0': special |= ST_ALLN; break;
     case '1': special |= ST_NIKO; break;
     case '8': special |= ST_BUOO; break;
     case '9': special |= (ST_DOSU | ST_ALLN); break;
     case 'd': special |= ST_HREN; break;
     case 'e': special |= ST_YAKU; break;
     case 'Y': special |= ST_CHIN; break;
     case 'Z': special |= ST_EROI; break;
#if 0
#ifdef KEYLOG
     case 'K': keyLog = MAKAI_TRUE; break;
#endif /* KEYLOG */
     case 'S':
      seedOffset = atoi( str + 4 );
      if ( seedOffset < MIN_SOFF || seedOffset > MAX_SOFF ) {
       fprintf( stderr, "̎̃ItZbǵA%d ȏ %d ȉŎw肵ĂˁB\n", MIN_SOFF, MAX_SOFF );
       fprintf( stderr, "%d ͔͈͊OȂ̂Ŗ܂B\n", seedOffset );
       seedOffset = 0;
      }
      break;
#endif /* 0 */
    }
   }
  }
}

/* qbgɂ͏o̓t@Cւ̃|C^Ԃ */
FILE *
checkSpecial( trip, kind )
char	*trip;
unsigned char	*kind;
{
  OLDPRINT( "trip %s\n", trip );

  if ( special & ST_CHIN ) {
   /* ^Chi(r */
   if ( trip[0] == 'C' && trip[1] == 'h' && trip[2] == 'i' &&
        trip[3] == 'n' && trip[4] == 'k' && trip[5] == 'o' ) {
    strcpy( kind, "" );
    return( cfp );
   }
  }

  if ( special & ST_BUOO ) {
   /* Ԃ [A-Za-z]aoo[A-Za-z]uoo$ */
   if ( trip[3] == 'a' && trip[4] == 'o' && trip[5] == 'o' &&
        trip[7] == 'u' && trip[8] == 'o' && trip[9] == 'o' &&
        isalpha( trip[2] ) && isalpha( trip[6] ) ) {
    strcpy( kind, "" );
    return( tfp );
   }
  }

  if ( special & ST_EROI ) {
   int	i;
   /* Gl^\  1 looooloooo */
   if ( trip[0] == trip[5] &&
        trip[1] == trip[2] && trip[1] == trip[3] && trip[1] == trip[4] &&
        trip[1] == trip[6] && trip[1] == trip[7] && trip[1] == trip[8] &&
        trip[1] == trip[9] ) {
    strcpy( kind, "G" );
    return( tfp );
   }
   /* Gl^\  2 [./] */
   for ( i = 0; i < TRIP_LEN; i++ ) {
    if ( trip[i] != '.' && trip[i] != '/' ) {
     goto NOEROI;
    }
   }
   strcpy( kind, "G" );
   return( tfp );
  }
  NOEROI:

  if ( special & ST_NIKO ) {
   /* \ */
   int	i;
   char	ch1, ch2;
   ch1 = trip[0];
   for ( i = 1; i < TRIP_LEN; i++ ) {
    if ( trip[i] != ch1 ) break;
   }
   ch2 = trip[i];
   for ( ; i < TRIP_LEN; i++ ) {
    if ( trip[i] != ch1 && trip[i] != ch2 ) goto NONIKO;
   }
   strcpy( kind, "" );
   return( tfp );
  }
  NONIKO:

  if ( special & ST_YAKU ) {
   /* _ */
   if ( trip[0] == trip[1] && trip[0] == trip[2] &&
        trip[3] == trip[4] && trip[3] == trip[5] &&
        trip[6] == trip[7] && trip[6] == trip[8] && trip[9] == '.' ) {
    strcpy( kind, "" );
    return( tfp );
   }
  }

  /* A֘ÃR[h́A Celeron/rc  */
  if ( special & ST_HREN ) {
   /* A */
   int	w, x = 0, y = 0;
   for ( w = 0; w < TRIP_LEN; w++ ) {
    if ( trip[w] == trip[0] ) x += 1;
    if ( trip[w] == trip[1] ) y += 1;
    if ( x >= 8 || y >= 8 ) {
     strcpy( kind, "" );
     return( tfp );
    }
   }
  }

  if ( special & ST_ALLN ) {
   /* S  { */
   if ( isdigit( trip[0] ) && isdigit( trip[1] ) && isdigit( trip[2] ) &&
        isdigit( trip[3] ) && isdigit( trip[4] ) && isdigit( trip[5] ) &&
        isdigit( trip[6] ) && isdigit( trip[7] ) && isdigit( trip[8] ) &&
        isdigit( trip[9] ) ) {
    if ( special & ST_DOSU ) {
     /* S &  */
     if ( trip[0] == trip[9] && trip[1] == trip[8] && trip[2] == trip[7] &&
          trip[3] == trip[6] && trip[4] == trip[5] ) {
      strcpy( kind, "{" );
      return( tfp );
     }
     /* S & oA */
     if ( trip[0] == trip[1] && trip[2] == trip[3] && trip[4] == trip[5] &&
          trip[6] == trip[7] && trip[8] == trip[9] ) {
      strcpy( kind, "{" );
      return( tfp );
     }
     /* S & RF */
     if ( trip[0] == trip[5] && trip[1] == trip[6] && trip[2] == trip[7] &&
          trip[3] == trip[8] && trip[4] == trip[9] ) {
      strcpy( kind, "{" );
      return( tfp );
     }
     /* őƍŏ́A 8 Aŏôō폜 */
    } else {
     strcpy( kind, "" );
     return( nfp );
    }
   }
  }

  return( NULL );
}
