package com.wiki.standalone.moxkiriya.parser.inlineparser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.wiki.standalone.moxkiriya.WikiEngine;

public class WikiLineThroughInlineParser extends WikiInlineParserBase {
	/** WIKIトークン */
	public static final String WIKI_TOKEN        = "--";

	/** WIKI記法の正規表現文字列　先頭頭パターン */
	public static final String PATTERN_START = "--[^-]";

	/** WIKI記法の正規表現文字列　末尾パターン */
	public static final String PATTERN_END = "[^-]--";

	/** 開始タグ */
	private static final String START_TAG = "<span id=\"linethrough\">\n";

	/** 終了タグ */
	private static final String END_TAG = "</span>\n";

	/**
	 * コンストラクタ
	 */
	public WikiLineThroughInlineParser(WikiEngine wikiEngine) {
		super(wikiEngine);
	}

	/**
	 * lineとWiki記法をマッチングする
	 * @param line
	 * @return マッチング結果
	 */
	public static boolean matches(String line) {
		boolean isMatch = false;
		
		Matcher startMatcher
			= Pattern.compile(WikiLineThroughInlineParser.PATTERN_START)
					.matcher(line);
		
		if(startMatcher.find() == true) {
			/*
			 * PATTERN_STARTの開始位置を取得
			 */						
			int     startIndex = startMatcher.start();
			
			/*
			 * PATTERN_ENDの開始位置を取得
			 */
			String   subline             = line.substring(startIndex);
			Matcher  underlineEndMatcher = Pattern.compile(WikiLineThroughInlineParser.PATTERN_END)
					.matcher(subline);
			
			if(underlineEndMatcher.find() == true) {
				isMatch = true;
			}
		}
		
		return isMatch;
	}

	@Override
	public String deleteWikiToken(String line) {
		String deleteTop = line.replaceFirst(WIKI_TOKEN, "");
		return deleteTop.substring(0, deleteTop.lastIndexOf(WIKI_TOKEN));
	}

	@Override
	public void startElementProcess(StringBuffer buf) {
		buf.append(START_TAG);
	}

	@Override
	public void endElementProcess(StringBuffer buf) {
		buf.append(END_TAG);
	}

	@Override
	public String getStartPattern() {
		return PATTERN_START;
	}

	@Override
	public String getEndPattern() {
		return PATTERN_END;
	}
}
