/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.terrain.heightmap;

import com.jme3.math.Vector3f;
import com.jme3.terrain.MapUtils;
import com.jme3.terrain.heightmap.AbstractHeightMap;
import com.jme3.terrain.heightmap.Grayscale16BitHeightMap;
import com.jme3.terrain.heightmap.HeightMap;
import com.jme3.terrain.heightmap.HeightMapGrid;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.imageio.ImageIO;
import org.novyon.noise.Basis;

public class FractalHeightMapGrid
implements HeightMapGrid {
    private int size;
    private final Basis base;
    private final String cacheDir;
    private final float heightScale;

    public FractalHeightMapGrid(Basis base, String cacheDir, float heightScale) {
        this.base = base;
        this.cacheDir = cacheDir;
        this.heightScale = heightScale;
    }

    public HeightMap getHeightMapAt(Vector3f location) {
        HeightMap heightmap = null;
        if (this.cacheDir != null && new File(this.cacheDir, "terrain_" + (int)location.x + "_" + (int)location.z + ".png").exists()) {
            try {
                BufferedImage im = null;
                im = ImageIO.read(new File(this.cacheDir, "terrain_" + (int)location.x + "_" + (int)location.z + ".png"));
                heightmap = new Grayscale16BitHeightMap(im);
                ((AbstractHeightMap)heightmap).setHeightScale(this.heightScale);
            }
            catch (IOException e) {}
        } else {
            FloatBuffer buffer = this.base.getBuffer(location.x * (float)(this.size - 1), location.z * (float)(this.size - 1), 0.0f, this.size);
            if (this.cacheDir != null) {
                MapUtils.saveImage(MapUtils.toGrayscale16Image(buffer, this.size), new File(this.cacheDir, "terrain_" + (int)location.x + "_" + (int)location.z + ".png"));
            }
            float[] arr = buffer.array();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = arr[i] * this.heightScale;
            }
            heightmap = new FloatBufferHeightMap(buffer);
        }
        heightmap.load();
        return heightmap;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public class FloatBufferHeightMap
    extends AbstractHeightMap {
        private final FloatBuffer buffer;

        public FloatBufferHeightMap(FloatBuffer buffer) {
            this.buffer = buffer;
        }

        public boolean load() {
            this.heightData = this.buffer.array();
            return true;
        }
    }
}

