/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class Torus
extends Mesh {
    private int circleSamples;
    private int radialSamples;
    private float innerRadius;
    private float outerRadius;

    public Torus() {
    }

    public Torus(int circleSamples, int radialSamples, float innerRadius, float outerRadius) {
        this.updateGeometry(circleSamples, radialSamples, innerRadius, outerRadius);
    }

    public int getCircleSamples() {
        return this.circleSamples;
    }

    public float getInnerRadius() {
        return this.innerRadius;
    }

    public float getOuterRadius() {
        return this.outerRadius;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.circleSamples = capsule.readInt("circleSamples", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
        this.innerRadius = capsule.readFloat("innerRadius", 0.0f);
        this.outerRadius = capsule.readFloat("outerRaidus", 0.0f);
    }

    private void setGeometryData() {
        int vertCount = (this.circleSamples + 1) * (this.radialSamples + 1);
        FloatBuffer fpb = BufferUtils.createVector3Buffer(vertCount);
        this.setBuffer(VertexBuffer.Type.Position, 3, fpb);
        FloatBuffer fnb = BufferUtils.createVector3Buffer(vertCount);
        this.setBuffer(VertexBuffer.Type.Normal, 3, fnb);
        FloatBuffer ftb = BufferUtils.createVector2Buffer(vertCount);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, ftb);
        float inverseCircleSamples = 1.0f / (float)this.circleSamples;
        float inverseRadialSamples = 1.0f / (float)this.radialSamples;
        int i = 0;
        Vector3f radialAxis = new Vector3f();
        Vector3f torusMiddle = new Vector3f();
        Vector3f tempNormal = new Vector3f();
        for (int circleCount = 0; circleCount < this.circleSamples; ++circleCount) {
            float circleFraction = (float)circleCount * inverseCircleSamples;
            float theta = (float)Math.PI * 2 * circleFraction;
            float cosTheta = FastMath.cos(theta);
            float sinTheta = FastMath.sin(theta);
            radialAxis.set(cosTheta, sinTheta, 0.0f);
            radialAxis.mult(this.outerRadius, torusMiddle);
            int iSave = i;
            for (int radialCount = 0; radialCount < this.radialSamples; ++radialCount) {
                float radialFraction = (float)radialCount * inverseRadialSamples;
                float phi = (float)Math.PI * 2 * radialFraction;
                float cosPhi = FastMath.cos(phi);
                float sinPhi = FastMath.sin(phi);
                tempNormal.set(radialAxis).multLocal(cosPhi);
                tempNormal.z += sinPhi;
                fnb.put(tempNormal.x).put(tempNormal.y).put(tempNormal.z);
                tempNormal.multLocal(this.innerRadius).addLocal(torusMiddle);
                fpb.put(tempNormal.x).put(tempNormal.y).put(tempNormal.z);
                ftb.put(radialFraction).put(circleFraction);
                ++i;
            }
            BufferUtils.copyInternalVector3(fpb, iSave, i);
            BufferUtils.copyInternalVector3(fnb, iSave, i);
            ftb.put(1.0f).put(circleFraction);
            ++i;
        }
        int iR = 0;
        while (iR <= this.radialSamples) {
            BufferUtils.copyInternalVector3(fpb, iR, i);
            BufferUtils.copyInternalVector3(fnb, iR, i);
            BufferUtils.copyInternalVector2(ftb, iR, i);
            ftb.put(i * 2 + 1, 1.0f);
            ++iR;
            ++i;
        }
    }

    private void setIndexData() {
        int triCount = 2 * this.circleSamples * this.radialSamples;
        ShortBuffer sib = BufferUtils.createShortBuffer(3 * triCount);
        this.setBuffer(VertexBuffer.Type.Index, 3, sib);
        int connectionStart = 0;
        int index = 0;
        for (int circleCount = 0; circleCount < this.circleSamples; ++circleCount) {
            int i0 = connectionStart;
            int i1 = i0 + 1;
            int i2 = connectionStart += this.radialSamples + 1;
            int i3 = i2 + 1;
            int i = 0;
            while (i < this.radialSamples) {
                sib.put((short)i0++);
                sib.put((short)i2);
                sib.put((short)i1);
                sib.put((short)i1++);
                sib.put((short)i2++);
                sib.put((short)i3++);
                ++i;
                index += 6;
            }
        }
    }

    public void updateGeometry(int circleSamples, int radialSamples, float innerRadius, float outerRadius) {
        this.circleSamples = circleSamples;
        this.radialSamples = radialSamples;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.setGeometryData();
        this.setIndexData();
        this.updateBound();
        this.updateCounts();
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.circleSamples, "circleSamples", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
        capsule.write(this.innerRadius, "innerRadius", 0.0f);
        capsule.write(this.outerRadius, "outerRadius", 0.0f);
    }
}

