/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.material.MaterialList;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class SceneMaterialLoader
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(SceneMaterialLoader.class.getName());
    private Stack<String> elementStack = new Stack();
    private String folderName;
    private MaterialList materialList;
    private AssetManager assetManager;
    private boolean ignoreItem = false;

    SceneMaterialLoader() {
    }

    private void reset() {
        this.elementStack.clear();
        this.materialList = null;
        this.ignoreItem = false;
    }

    private void checkTopNode(String topNode) throws SAXException {
        if (!this.elementStack.peek().equals(topNode)) {
            throw new SAXException("dotScene parse error: Expected parent node to be " + topNode);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (qName.equals("externals")) {
            this.checkTopNode("scene");
            this.materialList = new MaterialList();
        } else if (qName.equals("item")) {
            this.checkTopNode("externals");
            if (!attribs.getValue("type").equals("material")) {
                this.ignoreItem = true;
            }
        } else if (qName.equals("file")) {
            this.checkTopNode("item");
            if (!this.ignoreItem) {
                String materialPath = attribs.getValue("name");
                String materialName = new File(materialPath).getName();
                String matFile = this.folderName + materialName;
                try {
                    MaterialList loadedMaterialList = this.assetManager.loadAsset(new OgreMaterialKey(matFile));
                    this.materialList.putAll(loadedMaterialList);
                }
                catch (AssetNotFoundException ex) {
                    logger.log(Level.WARNING, "Cannot locate material file: {0}", matFile);
                }
            }
        }
        this.elementStack.push(qName);
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (qName.equals("item") && this.ignoreItem) {
            this.ignoreItem = false;
        }
        this.checkTopNode(qName);
        this.elementStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterialList load(AssetManager assetManager, String folderName, InputStream in) throws IOException {
        try {
            this.assetManager = assetManager;
            this.folderName = folderName;
            this.reset();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = factory.newSAXParser().getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            InputStreamReader r = null;
            try {
                r = new InputStreamReader(in);
                xr.parse(new InputSource(r));
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            return this.materialList;
        }
        catch (SAXException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            throw ioEx;
        }
        catch (ParserConfigurationException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

