/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender;

import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.Properties;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractBlenderHelper {
    protected BlenderContext blenderContext;
    protected final int blenderVersion;
    protected boolean fixUpAxis;
    protected Quaternion upAxisRotationQuaternion;

    public AbstractBlenderHelper(String blenderVersion, BlenderContext blenderContext) {
        this.blenderVersion = Integer.parseInt(blenderVersion);
        this.blenderContext = blenderContext;
        this.fixUpAxis = blenderContext.getBlenderKey().isFixUpAxis();
        if (this.fixUpAxis) {
            this.upAxisRotationQuaternion = new Quaternion().fromAngles(-1.5707964f, 0.0f, 0.0f);
        }
    }

    public void clearState() {
    }

    protected boolean isBlank(String text) {
        if (text != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected Properties loadProperties(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pProperties;
        Properties properties = null;
        Structure id2 = (Structure)structure.getFieldValue("ID");
        if (id2 != null && (pProperties = (Pointer)id2.getFieldValue("properties")).isNotNull()) {
            Structure propertiesStructure = pProperties.fetchData(blenderContext.getInputStream()).get(0);
            properties = new Properties();
            properties.load(propertiesStructure, blenderContext);
        }
        return properties;
    }

    protected void applyProperties(Spatial spatial, Properties properties) {
        List<String> propertyNames = properties.getSubPropertiesNames();
        if (propertyNames != null && propertyNames.size() > 0) {
            for (String propertyName : propertyNames) {
                Object value = properties.findValue(propertyName);
                if (value instanceof Savable || value instanceof Boolean || value instanceof String || value instanceof Float || value instanceof Integer || value instanceof Long) {
                    spatial.setUserData(propertyName, value);
                    continue;
                }
                if (value instanceof Double) {
                    spatial.setUserData(propertyName, Float.valueOf(((Double)value).floatValue()));
                    continue;
                }
                if (value instanceof int[]) {
                    spatial.setUserData(propertyName, Arrays.toString((int[])value));
                    continue;
                }
                if (value instanceof float[]) {
                    spatial.setUserData(propertyName, Arrays.toString((float[])value));
                    continue;
                }
                if (!(value instanceof double[])) continue;
                spatial.setUserData(propertyName, Arrays.toString((double[])value));
            }
        }
    }

    public abstract boolean shouldBeLoaded(Structure var1, BlenderContext var2);
}

