/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.asset.TextureKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.FixedFuncBinding;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.renderer.Renderer;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class MatParam
implements Savable,
Cloneable {
    protected VarType type;
    protected String name;
    protected String prefixedName;
    protected Object value;
    protected FixedFuncBinding ffBinding;
    protected FloatBuffer multiData = null;

    public MatParam(VarType type, String name, Object value, FixedFuncBinding ffBinding) {
        this.type = type;
        this.name = name;
        this.prefixedName = "m_" + name;
        this.value = value;
        this.ffBinding = ffBinding;
    }

    public MatParam() {
    }

    public FixedFuncBinding getFixedFuncBinding() {
        return this.ffBinding;
    }

    public VarType getVarType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefixedName() {
        return this.prefixedName;
    }

    void setName(String name) {
        this.name = name;
        this.prefixedName = "m_" + name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        if (value instanceof FloatBuffer) {
            this.multiData = (FloatBuffer)value;
            return;
        }
        switch (this.type) {
            case Matrix3: {
                Matrix3f m3 = (Matrix3f)value;
                if (this.multiData == null) {
                    this.multiData = BufferUtils.createFloatBuffer(9);
                }
                m3.fillFloatBuffer(this.multiData, true);
                this.multiData.clear();
                break;
            }
            case Matrix4: {
                Matrix4f m4 = (Matrix4f)value;
                if (this.multiData == null) {
                    this.multiData = BufferUtils.createFloatBuffer(16);
                }
                m4.fillFloatBuffer(this.multiData, true);
                this.multiData.clear();
                break;
            }
            case FloatArray: {
                float[] fa = (float[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(fa) : BufferUtils.ensureLargeEnough(this.multiData, fa.length);
                this.multiData.put(fa);
                this.multiData.clear();
                break;
            }
            case Vector2Array: {
                Vector2f[] v2a = (Vector2f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v2a) : BufferUtils.ensureLargeEnough(this.multiData, v2a.length * 2);
                for (int i = 0; i < v2a.length; ++i) {
                    BufferUtils.setInBuffer(v2a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Vector3Array: {
                Vector3f[] v3a = (Vector3f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v3a) : BufferUtils.ensureLargeEnough(this.multiData, v3a.length * 3);
                for (int i = 0; i < v3a.length; ++i) {
                    BufferUtils.setInBuffer(v3a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Vector4Array: {
                Quaternion[] v4a = (Quaternion[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(v4a) : BufferUtils.ensureLargeEnough(this.multiData, v4a.length * 4);
                for (int i = 0; i < v4a.length; ++i) {
                    BufferUtils.setInBuffer(v4a[i], this.multiData, i);
                }
                this.multiData.clear();
                break;
            }
            case Matrix3Array: {
                Matrix3f[] m3a = (Matrix3f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(m3a.length * 9) : BufferUtils.ensureLargeEnough(this.multiData, m3a.length * 9);
                for (int i = 0; i < m3a.length; ++i) {
                    m3a[i].fillFloatBuffer(this.multiData, true);
                }
                this.multiData.clear();
                break;
            }
            case Matrix4Array: {
                Matrix4f[] m4a = (Matrix4f[])value;
                this.multiData = this.multiData == null ? BufferUtils.createFloatBuffer(m4a.length * 16) : BufferUtils.ensureLargeEnough(this.multiData, m4a.length * 16);
                for (int i = 0; i < m4a.length; ++i) {
                    m4a[i].fillFloatBuffer(this.multiData, true);
                }
                this.multiData.clear();
                break;
            }
            case Int: 
            case Float: 
            case Boolean: {
                if (this.value != null && this.value.equals(value)) {
                    return;
                }
                this.value = value;
                this.multiData = null;
                break;
            }
            default: {
                this.value = value;
                this.multiData = null;
            }
        }
    }

    void apply(Renderer r, Technique technique) {
        TechniqueDef techDef = technique.getDef();
        if (techDef.isUsingShaders()) {
            Object value;
            if (this.multiData != null) {
                value = this.multiData;
                this.multiData.clear();
            } else {
                value = this.getValue();
            }
            technique.updateUniformParam(this.getPrefixedName(), this.getVarType(), value, true);
        }
    }

    void apply(Renderer r, Technique technique, int paramIndex) {
        TechniqueDef techDef = technique.getDef();
        if (techDef.isUsingShaders()) {
            Object value;
            if (this.multiData != null) {
                value = this.multiData;
                this.multiData.clear();
            } else {
                value = this.getValue();
            }
            technique.updateUniformParam(paramIndex, this.getVarType(), value, true);
        }
    }

    public String getValueAsString() {
        switch (this.type) {
            case Int: 
            case Float: 
            case Boolean: {
                return this.value.toString();
            }
            case Vector2: {
                Vector2f v2 = (Vector2f)this.value;
                return v2.getX() + " " + v2.getY();
            }
            case Vector3: {
                Vector3f v3 = (Vector3f)this.value;
                return v3.getX() + " " + v3.getY() + " " + v3.getZ();
            }
            case Vector4: {
                if (this.value instanceof Vector4f) {
                    Vector4f v4 = (Vector4f)this.value;
                    return v4.getX() + " " + v4.getY() + " " + v4.getZ() + " " + v4.getW();
                }
                if (this.value instanceof ColorRGBA) {
                    ColorRGBA color = (ColorRGBA)this.value;
                    return color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " " + color.getAlpha();
                }
                if (this.value instanceof Quaternion) {
                    Quaternion quat = (Quaternion)this.value;
                    return quat.getX() + " " + quat.getY() + " " + quat.getZ() + " " + quat.getW();
                }
                throw new UnsupportedOperationException("Unexpected Vector4 type: " + this.value);
            }
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureBuffer: 
            case TextureCubeMap: {
                Texture texVal = (Texture)this.value;
                TextureKey texKey = (TextureKey)texVal.getKey();
                if (texKey == null) {
                    throw new UnsupportedOperationException("The specified MatParam cannot be represented in J3M");
                }
                String ret = "";
                if (texKey.isFlipY()) {
                    ret = ret + "Flip ";
                }
                if (texVal.getWrap(Texture.WrapAxis.S) == Texture.WrapMode.Repeat) {
                    ret = ret + "Repeat ";
                }
                return ret + texKey.getName();
            }
        }
        return null;
    }

    public MatParam clone() {
        try {
            MatParam param = (MatParam)super.clone();
            return param;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.type, "varType", null);
        oc.write(this.name, "name", null);
        oc.write(this.ffBinding, "ff_binding", null);
        if (this.value instanceof Savable) {
            Savable s = (Savable)this.value;
            oc.write(s, "value_savable", null);
        } else if (this.value instanceof Float) {
            Float f = (Float)this.value;
            oc.write(f.floatValue(), "value_float", 0.0f);
        } else if (this.value instanceof Integer) {
            Integer i = (Integer)this.value;
            oc.write(i, "value_int", 0);
        } else if (this.value instanceof Boolean) {
            Boolean b = (Boolean)this.value;
            oc.write(b, "value_bool", false);
        }
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.type = ic.readEnum("varType", VarType.class, null);
        this.name = ic.readString("name", null);
        this.ffBinding = ic.readEnum("ff_binding", FixedFuncBinding.class, null);
        switch (this.getVarType()) {
            case Boolean: {
                this.value = ic.readBoolean("value_bool", false);
                break;
            }
            case Float: {
                this.value = Float.valueOf(ic.readFloat("value_float", 0.0f));
                break;
            }
            case Int: {
                this.value = ic.readInt("value_int", 0);
                break;
            }
            default: {
                this.value = ic.readSavable("value_savable", null);
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof MatParam)) {
            return false;
        }
        MatParam otherParam = (MatParam)other;
        return otherParam.type == this.type && otherParam.name.equals(this.name);
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.type.name() + " " + this.name + " : " + this.getValueAsString();
    }
}

