/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import de.lessvoid.nifty.Nifty;
import java.io.IOException;

public class GuiTrack
extends AbstractCinematicEvent {
    protected String screen;
    protected Nifty nifty;

    public GuiTrack() {
    }

    public GuiTrack(String screen) {
        this.screen = screen;
    }

    public GuiTrack(String screen, float initialDuration) {
        super(initialDuration);
        this.screen = screen;
    }

    public GuiTrack(String screen, LoopMode loopMode) {
        super(loopMode);
        this.screen = screen;
    }

    public GuiTrack(String screen, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.screen = screen;
    }

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        this.nifty = cinematic.getNifty();
    }

    public void onPlay() {
        this.nifty.gotoScreen(this.screen);
    }

    public void onStop() {
        this.nifty.gotoScreen("");
    }

    public void onPause() {
    }

    public void setNifty(Nifty nifty) {
        this.nifty = nifty;
    }

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public void onUpdate(float tpf) {
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.screen, "screen", "");
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.screen = ic.readString("screen", "");
    }
}

