/*
 * Decompiled with CFR 0.152.
 */
package jme3test.android;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestNormalMapping
extends SimpleApplication {
    float angle;
    PointLight pl;
    Spatial lightMdl;

    public static void main(String[] args) {
        TestNormalMapping app = new TestNormalMapping();
        app.start();
    }

    @Override
    public void simpleInitApp() {
        Sphere sphMesh = new Sphere(32, 32, 1.0f);
        sphMesh.setTextureMode(Sphere.TextureMode.Projected);
        sphMesh.updateGeometry(32, 32, 1.0f, false, false);
        TangentBinormalGenerator.generate(sphMesh);
        Geometry sphere = new Geometry("Rock Ball", sphMesh);
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Pond/Pond.j3m");
        sphere.setMaterial(mat);
        this.rootNode.attachChild(sphere);
        this.lightMdl = new Geometry("Light", new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.rootNode.attachChild(this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(ColorRGBA.White);
        this.pl.setPosition(new Vector3f(0.0f, 0.0f, 4.0f));
        this.rootNode.addLight(this.pl);
        AmbientLight al = new AmbientLight();
        al.setColor(new ColorRGBA(0.44f, 0.4f, 0.2f, 1.0f));
        this.rootNode.addLight(al);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.92f, 0.85f, 0.8f, 1.0f));
        this.rootNode.addLight(dl);
    }

    @Override
    public void simpleUpdate(float tpf) {
        this.angle += tpf * 0.25f;
        this.angle %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos(this.angle) * 4.0f, 0.5f, FastMath.sin(this.angle) * 4.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

