/*
 * Decompiled with CFR 0.152.
 */
package jme3test.android;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestBumpModel
extends SimpleApplication {
    float angle;
    PointLight pl;
    Spatial lightMdl;

    public static void main(String[] args) {
        TestBumpModel app = new TestBumpModel();
        app.start();
    }

    @Override
    public void simpleInitApp() {
        Spatial signpost = this.assetManager.loadAsset(new OgreMeshKey("Models/Sign Post/Sign Post.mesh.xml"));
        signpost.setMaterial(this.assetManager.loadMaterial("Models/Sign Post/Sign Post.j3m"));
        TangentBinormalGenerator.generate(signpost);
        this.rootNode.attachChild(signpost);
        this.lightMdl = new Geometry("Light", new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.rootNode.attachChild(this.lightMdl);
        this.pl = new PointLight();
        this.pl.setColor(new ColorRGBA(0.88f, 0.92f, 0.95f, 1.0f));
        this.rootNode.addLight(this.pl);
        AmbientLight al = new AmbientLight();
        al.setColor(new ColorRGBA(0.44f, 0.4f, 0.2f, 1.0f));
        this.rootNode.addLight(al);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(0.92f, 0.85f, 0.8f, 1.0f));
        this.rootNode.addLight(dl);
    }

    @Override
    public void simpleUpdate(float tpf) {
        this.angle += tpf * 0.25f;
        this.angle %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos(this.angle) * 6.0f, 3.0f, FastMath.sin(this.angle) * 6.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
    }
}

