/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.video.plugins.jheora;

import com.fluendo.jheora.Comment;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.jcraft.jogg.Packet;
import com.jme3.video.Clock;
import com.jme3.video.SystemClock;
import com.jme3.video.VFrame;
import com.jme3.video.VQueue;
import com.jme3.video.plugins.jheora.YUVConv;
import java.nio.ByteBuffer;

@Deprecated
public class VDecoder
implements Clock {
    private int packetIndex = 0;
    private Info info;
    private Comment comment;
    private State state;
    private YUVBuffer yuv;
    private int xOff;
    private int yOff;
    private int width;
    private int height;
    private YUVConv conv = new YUVConv();
    private VQueue videoQueue;
    private long lastTs = -1L;
    private long lastUpdateTime = 0L;
    private Clock masterClock;

    public VDecoder(VQueue queue) {
        this.info = new Info();
        this.comment = new Comment();
        this.state = new State();
        this.yuv = new YUVBuffer();
        this.videoQueue = queue;
    }

    public void setMasterClock(Clock masterClock) {
        this.masterClock = masterClock;
    }

    public long getTime() {
        if (this.lastTs == -1L) {
            return 0L;
        }
        long timeDiff = System.nanoTime() - this.lastUpdateTime;
        return this.lastTs + timeDiff;
    }

    public double getTimeSeconds() {
        return (double)this.getTime() / 1.0E9;
    }

    private void initializeFrames() {
        for (int i = 0; i < this.videoQueue.remainingCapacity(); ++i) {
            this.videoQueue.returnFrame(new VFrame(this.width, this.height));
        }
    }

    private void decodeRgbFromBuffer(long time) {
        VFrame frame = this.videoQueue.nextReturnedFrame(true);
        this.conv.convert(this.yuv, this.xOff, this.yOff, this.width, this.height);
        int[] rgb = this.conv.getRGBData();
        frame.setTime(time);
        ByteBuffer data = frame.getImage().getData(0);
        data.clear();
        data.asIntBuffer().put(rgb);
        try {
            this.videoQueue.put(frame);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public void close() {
        VFrame frame = this.videoQueue.nextReturnedFrame(true);
        frame.setTime(-2L);
        try {
            this.videoQueue.put(frame);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void decode(Packet packet) {
        if (this.packetIndex < 3) {
            if (this.info.decodeHeader(this.comment, packet) < 0) {
                System.err.println("does not contain Theora video data.");
                return;
            }
            if (this.packetIndex == 2) {
                SystemClock clock;
                this.state.decodeInit(this.info);
                System.out.println("theora frame: " + this.info.frame_width + "x" + this.info.frame_height);
                System.out.println("theora resolution: " + this.info.width + "x" + this.info.height);
                System.out.println("theora aspect: " + this.info.aspect_numerator + "x" + this.info.aspect_denominator);
                System.out.println("theora framerate: " + this.info.fps_numerator + "x" + this.info.fps_denominator);
                this.xOff = this.info.offset_x;
                this.yOff = this.info.offset_y;
                this.width = this.info.frame_width;
                this.height = this.info.frame_height;
                this.initializeFrames();
                if (this.masterClock instanceof SystemClock && (clock = (SystemClock)this.masterClock).needReset()) {
                    clock.reset();
                    System.out.println("Note: master clock was reset by video");
                }
            }
        } else {
            long granulePos = packet.granulepos;
            long time = (long)(this.state.granuleTime(granulePos) * 1.0E9);
            long oneFrameTime = 1000000000L * (long)this.info.fps_denominator / (long)this.info.fps_numerator;
            if (time >= 0L) {
                this.lastTs = time;
            } else {
                this.lastTs += oneFrameTime;
                time = this.lastTs;
            }
            this.lastUpdateTime = System.nanoTime();
            if (this.state.decodePacketin(packet) != 0) {
                System.err.println("Error Decoding Theora.");
                return;
            }
            if (this.state.decodeYUVout(this.yuv) != 0) {
                System.err.println("Error getting the picture.");
                return;
            }
            this.decodeRgbFromBuffer(time);
        }
        ++this.packetIndex;
    }
}

