/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.image;

import com.jme3.texture.Image;
import com.jme3.texture.image.BitMaskImageCodec;
import com.jme3.texture.image.ByteAlignedImageCodec;
import com.jme3.texture.image.ByteOffsetImageCodec;
import java.nio.ByteBuffer;
import java.util.EnumMap;

abstract class ImageCodec {
    public static final int FLAG_F16 = 1;
    public static final int FLAG_F32 = 2;
    public static final int FLAG_GRAY = 4;
    private static final EnumMap<Image.Format, ImageCodec> params = new EnumMap(Image.Format.class);
    protected final int bpp;
    protected final int type;
    protected final int maxAlpha;
    protected final int maxRed;
    protected final int maxGreen;
    protected final int maxBlue;
    protected final boolean isGray;

    public ImageCodec(int bpp, int flags, int maxAlpha, int maxRed, int maxGreen, int maxBlue) {
        this.bpp = bpp;
        this.isGray = (flags & 4) != 0;
        this.type = flags & 0xFFFFFFFB;
        this.maxAlpha = maxAlpha;
        this.maxRed = maxRed;
        this.maxGreen = maxGreen;
        this.maxBlue = maxBlue;
    }

    public abstract void readComponents(ByteBuffer var1, int var2, int var3, int var4, int[] var5, byte[] var6);

    public abstract void writeComponents(ByteBuffer var1, int var2, int var3, int var4, int[] var5, byte[] var6);

    public static ImageCodec lookup(Image.Format format) {
        ImageCodec codec = params.get((Object)format);
        if (codec == null) {
            throw new UnsupportedOperationException("The format " + (Object)((Object)format) + " is not supported");
        }
        return codec;
    }

    static {
        params.put(Image.Format.Alpha8, new ByteOffsetImageCodec(1, 0, 0, -1, -1, -1));
        params.put(Image.Format.Alpha16, new BitMaskImageCodec(2, 0, 16, 0, 0, 0, 0, 0, 0, 0));
        params.put(Image.Format.Luminance8, new ByteOffsetImageCodec(1, 4, -1, 0, -1, -1));
        params.put(Image.Format.Luminance16, new BitMaskImageCodec(2, 4, 0, 16, 0, 0, 0, 0, 0, 0));
        params.put(Image.Format.Luminance16F, new BitMaskImageCodec(2, 5, 0, 16, 0, 0, 0, 0, 0, 0));
        params.put(Image.Format.Luminance32F, new BitMaskImageCodec(4, 6, 0, 32, 0, 0, 0, 0, 0, 0));
        params.put(Image.Format.Luminance8Alpha8, new ByteOffsetImageCodec(2, 4, 1, 0, -1, -1));
        params.put(Image.Format.Luminance16Alpha16, new BitMaskImageCodec(4, 4, 16, 16, 0, 0, 16, 0, 0, 0));
        params.put(Image.Format.Luminance16FAlpha16F, new BitMaskImageCodec(4, 5, 16, 16, 0, 0, 16, 0, 0, 0));
        params.put(Image.Format.BGR8, new ByteOffsetImageCodec(3, 0, -1, 2, 1, 0));
        params.put(Image.Format.RGB565, new BitMaskImageCodec(2, 0, 0, 5, 6, 5, 0, 11, 5, 0));
        params.put(Image.Format.RGB8, new ByteOffsetImageCodec(3, 0, -1, 0, 1, 2));
        params.put(Image.Format.RGB16, new ByteAlignedImageCodec(6, 0, 0, 2, 2, 2, 0, 0, 2, 4));
        params.put(Image.Format.RGB32F, new ByteAlignedImageCodec(12, 2, 0, 4, 4, 4, 0, 0, 4, 8));
        ByteAlignedImageCodec rgb16f = new ByteAlignedImageCodec(6, 1, 0, 2, 2, 2, 0, 0, 2, 4);
        params.put(Image.Format.RGB16F, rgb16f);
        params.put(Image.Format.RGB16F_to_RGB111110F, rgb16f);
        params.put(Image.Format.RGB16F_to_RGB9E5, rgb16f);
        params.put(Image.Format.ABGR8, new ByteOffsetImageCodec(4, 0, 0, 3, 2, 1));
        params.put(Image.Format.ARGB4444, new BitMaskImageCodec(2, 0, 4, 4, 4, 4, 12, 0, 4, 8));
        params.put(Image.Format.RGB5A1, new BitMaskImageCodec(2, 0, 1, 5, 5, 5, 0, 11, 6, 1));
        ((BitMaskImageCodec)ImageCodec.params.get((Object)((Object)Image.Format.RGB5A1))).be = true;
        params.put(Image.Format.RGBA8, new ByteOffsetImageCodec(4, 0, 3, 0, 1, 2));
        params.put(Image.Format.RGBA16, new ByteAlignedImageCodec(8, 0, 2, 2, 2, 2, 6, 0, 2, 4));
        params.put(Image.Format.RGBA16F, new ByteAlignedImageCodec(8, 1, 2, 2, 2, 2, 6, 0, 2, 4));
        params.put(Image.Format.RGBA32F, new ByteAlignedImageCodec(16, 2, 4, 4, 4, 4, 12, 0, 4, 8));
    }
}

