/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorMusgrave
extends TextureGenerator {
    protected MusgraveData musgraveData;
    protected NoiseGenerator.MusgraveFunction musgraveFunction;
    protected int stype;
    protected float noisesize;

    public TextureGeneratorMusgrave(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.musgraveData = new MusgraveData(tex);
        this.stype = ((Number)tex.getFieldValue("stype")).intValue();
        this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        this.musgraveFunction = NoiseGenerator.musgraveFunctions.get(this.musgraveData.stype);
        if (this.musgraveFunction == null) {
            throw new IllegalStateException("Unknown type of musgrave texture: " + this.stype);
        }
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        pixel.intensity = this.musgraveData.outscale * this.musgraveFunction.execute(this.musgraveData, x, y, z);
        if (pixel.intensity > 1.0f) {
            pixel.intensity = 1.0f;
        } else if (pixel.intensity < 0.0f) {
            pixel.intensity = 0.0f;
        }
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
            pixel.alpha = this.colorBand[colorbandIndex][3];
        } else {
            this.applyBrightnessAndContrast(this.bacd, pixel);
        }
    }

    protected static class MusgraveData {
        public final int stype;
        public final float outscale;
        public final float h;
        public final float lacunarity;
        public final float octaves;
        public final int noisebasis;
        public final float offset;
        public final float gain;

        public MusgraveData(Structure tex) {
            this.stype = ((Number)tex.getFieldValue("stype")).intValue();
            this.outscale = ((Number)tex.getFieldValue("ns_outscale")).floatValue();
            this.h = ((Number)tex.getFieldValue("mg_H")).floatValue();
            this.lacunarity = ((Number)tex.getFieldValue("mg_lacunarity")).floatValue();
            this.octaves = ((Number)tex.getFieldValue("mg_octaves")).floatValue();
            this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
            this.offset = ((Number)tex.getFieldValue("mg_offset")).floatValue();
            this.gain = ((Number)tex.getFieldValue("mg_gain")).floatValue();
        }
    }
}

