/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.math.Vector2f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.GeneratedTexture;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.TriangulatedTexture;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.scene.plugins.blender.textures.UVProjectionGenerator;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlenderFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedTexture {
    private static final Logger LOGGER = Logger.getLogger(CombinedTexture.class.getName());
    private final int mappingType;
    private List<TextureData> textureDatas = new ArrayList<TextureData>();
    private boolean wasTriangulated;
    private Texture resultTexture;
    private List<Vector2f> resultUVS;

    public CombinedTexture(int mappingType) {
        this.mappingType = mappingType;
    }

    public void add(Texture texture, TextureBlender textureBlender, int uvCoordinatesType, int projectionType, Structure textureStructure, BlenderContext blenderContext) {
        if (!(texture instanceof GeneratedTexture) && !(texture instanceof Texture2D)) {
            throw new IllegalArgumentException("Unsupported texture type: " + (texture == null ? "null" : texture.getClass()));
        }
        if (!(texture instanceof GeneratedTexture) || blenderContext.getBlenderKey().isLoadGeneratedTextures()) {
            if (UVCoordinatesGenerator.isTextureCoordinateTypeSupported(UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType))) {
                TextureData textureData = new TextureData();
                textureData.texture = texture;
                textureData.textureBlender = textureBlender;
                textureData.uvCoordinatesType = UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType);
                textureData.projectionType = UVProjectionGenerator.UVProjectionType.valueOf(projectionType);
                textureData.textureStructure = textureStructure;
                if (this.textureDatas.size() > 0 && this.isWithoutAlpha(textureData, blenderContext)) {
                    this.textureDatas.clear();
                }
                this.textureDatas.add(textureData);
            } else {
                LOGGER.warning("The texture coordinates type is not supported: " + (Object)((Object)UVCoordinatesGenerator.UVCoordinatesType.valueOf(uvCoordinatesType)) + ". The texture '" + textureStructure.getName() + "'.");
            }
        }
    }

    public void flatten(Geometry geometry, Long geometriesOMA, List<Vector2f> userDefinedUVCoordinates, BlenderContext blenderContext) {
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        Mesh mesh = geometry.getMesh();
        Texture previousTexture = null;
        UVCoordinatesGenerator.UVCoordinatesType masterUVCoordinatesType = null;
        for (TextureData textureData : this.textureDatas) {
            if (this.textureDatas.size() > 1 && textureData.texture.getImage().getFormat().isCompressed()) {
                textureData.texture.setImage(textureHelper.decompress(textureData.texture.getImage()));
                textureData.textureBlender = TextureBlenderFactory.alterTextureType(textureData.texture.getImage().getFormat(), textureData.textureBlender);
            }
            if (previousTexture == null) {
                if (textureData.texture instanceof GeneratedTexture) {
                    this.resultTexture = ((GeneratedTexture)textureData.texture).triangulate(mesh, geometriesOMA, textureData.uvCoordinatesType, blenderContext);
                } else if (textureData.texture instanceof Texture2D) {
                    this.resultTexture = textureData.texture;
                    if (textureData.uvCoordinatesType == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV && userDefinedUVCoordinates != null && userDefinedUVCoordinates.size() > 0) {
                        this.resultUVS = userDefinedUVCoordinates;
                    } else {
                        List geometries = (List)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                        this.resultUVS = UVCoordinatesGenerator.generateUVCoordinatesFor2DTexture(mesh, textureData.uvCoordinatesType, textureData.projectionType, geometries);
                    }
                }
                this.blend(this.resultTexture, textureData.textureBlender, blenderContext);
                previousTexture = this.resultTexture;
                masterUVCoordinatesType = textureData.uvCoordinatesType;
                continue;
            }
            if (textureData.texture instanceof GeneratedTexture) {
                if (!(this.resultTexture instanceof TriangulatedTexture)) {
                    this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                    this.resultUVS = null;
                    previousTexture = this.resultTexture;
                }
                TriangulatedTexture triangulatedTexture = ((GeneratedTexture)textureData.texture).triangulate(mesh, geometriesOMA, textureData.uvCoordinatesType, blenderContext);
                triangulatedTexture.castToUVS((TriangulatedTexture)this.resultTexture, blenderContext);
                triangulatedTexture.blend(textureData.textureBlender, (TriangulatedTexture)this.resultTexture, blenderContext);
                this.resultTexture = previousTexture = triangulatedTexture;
                continue;
            }
            if (!(textureData.texture instanceof Texture2D)) continue;
            if (masterUVCoordinatesType == textureData.uvCoordinatesType && this.resultTexture instanceof Texture2D) {
                this.scale((Texture2D)textureData.texture, this.resultTexture.getImage().getWidth(), this.resultTexture.getImage().getHeight());
                this.merge((Texture2D)this.resultTexture, (Texture2D)textureData.texture);
                previousTexture = this.resultTexture;
                continue;
            }
            if (!(this.resultTexture instanceof TriangulatedTexture)) {
                this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                this.resultUVS = null;
            }
            List<Vector2f> textureUVS = null;
            if (textureData.uvCoordinatesType == UVCoordinatesGenerator.UVCoordinatesType.TEXCO_UV && userDefinedUVCoordinates != null && userDefinedUVCoordinates.size() > 0) {
                textureUVS = userDefinedUVCoordinates;
            } else {
                List geometries = (List)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
                textureUVS = UVCoordinatesGenerator.generateUVCoordinatesFor2DTexture(mesh, textureData.uvCoordinatesType, textureData.projectionType, geometries);
            }
            TriangulatedTexture triangulatedTexture = new TriangulatedTexture((Texture2D)textureData.texture, textureUVS, blenderContext);
            triangulatedTexture.castToUVS((TriangulatedTexture)this.resultTexture, blenderContext);
            ((TriangulatedTexture)this.resultTexture).merge(triangulatedTexture);
        }
        if (this.resultTexture instanceof TriangulatedTexture) {
            if (this.mappingType == 2) {
                for (int i = 0; i < ((TriangulatedTexture)this.resultTexture).getFaceTextureCount(); ++i) {
                    TriangulatedTexture.TriangleTextureElement triangleTextureElement = ((TriangulatedTexture)this.resultTexture).getFaceTextureElement(i);
                    triangleTextureElement.image = textureHelper.convertToNormalMapTexture(triangleTextureElement.image, 1.0f);
                }
            }
            this.resultUVS = ((TriangulatedTexture)this.resultTexture).getResultUVS();
            this.resultTexture = ((TriangulatedTexture)this.resultTexture).getResultTexture();
            this.wasTriangulated = true;
        }
        this.resultTexture.setWrap(Texture.WrapMode.Repeat);
        this.resultTexture.setMagFilter(Texture.MagFilter.Nearest);
        this.resultTexture.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
    }

    private void blend(Texture texture, TextureBlender textureBlender, BlenderContext blenderContext) {
        if (texture instanceof TriangulatedTexture) {
            ((TriangulatedTexture)texture).blend(textureBlender, null, blenderContext);
        } else if (texture instanceof Texture2D) {
            Image blendedImage = textureBlender.blend(texture.getImage(), null, blenderContext);
            texture.setImage(blendedImage);
        } else {
            throw new IllegalArgumentException("Invalid type for texture to blend!");
        }
    }

    public void castToUVS(CombinedTexture basicUVSOwner, BlenderContext blenderContext) {
        if (this.resultUVS.size() != basicUVSOwner.resultUVS.size()) {
            throw new IllegalStateException("The amount of UV coordinates must be equal in order to cast one UV's onto another!");
        }
        if (!this.resultUVS.equals(basicUVSOwner.resultUVS)) {
            if (!basicUVSOwner.wasTriangulated) {
                throw new IllegalStateException("The given texture must be triangulated!");
            }
            if (!this.wasTriangulated) {
                this.resultTexture = new TriangulatedTexture((Texture2D)this.resultTexture, this.resultUVS, blenderContext);
                this.resultUVS = ((TriangulatedTexture)this.resultTexture).getResultUVS();
                this.resultTexture = ((TriangulatedTexture)this.resultTexture).getResultTexture();
            }
            TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
            ImageLoader imageLoader = new ImageLoader();
            ArrayList<TriangulatedTexture.TriangleTextureElement> faceTextures = new ArrayList<TriangulatedTexture.TriangleTextureElement>();
            List<Vector2f> basicUVS = basicUVSOwner.getResultUVS();
            int[] imageRectangle = new int[4];
            int[] sourceSize = new int[2];
            int[] targetSize = new int[2];
            Vector2f[] destinationUVS = new Vector2f[3];
            Vector2f[] sourceUVS = new Vector2f[3];
            List<Vector2f> partImageUVS = Arrays.asList(new Vector2f(), new Vector2f(), new Vector2f());
            int faceIndex = 0;
            for (int i = 0; i < basicUVS.size(); i += 3) {
                destinationUVS[0] = basicUVS.get(i);
                destinationUVS[1] = basicUVS.get(i + 1);
                destinationUVS[2] = basicUVS.get(i + 2);
                this.computeImageRectangle(destinationUVS, imageRectangle, basicUVSOwner.resultTexture.getImage().getWidth(), basicUVSOwner.resultTexture.getImage().getHeight(), blenderContext);
                targetSize[0] = imageRectangle[2] - imageRectangle[0];
                targetSize[1] = imageRectangle[3] - imageRectangle[1];
                for (int j = 0; j < 3; ++j) {
                    partImageUVS.get(j).set(((float)basicUVSOwner.resultTexture.getImage().getWidth() * destinationUVS[j].x - (float)imageRectangle[0]) / (float)targetSize[0], ((float)basicUVSOwner.resultTexture.getImage().getHeight() * destinationUVS[j].y - (float)imageRectangle[1]) / (float)targetSize[1]);
                }
                sourceUVS[0] = this.resultUVS.get(i);
                sourceUVS[1] = this.resultUVS.get(i + 1);
                sourceUVS[2] = this.resultUVS.get(i + 2);
                this.computeImageRectangle(sourceUVS, imageRectangle, this.resultTexture.getImage().getWidth(), this.resultTexture.getImage().getHeight(), blenderContext);
                sourceSize[0] = imageRectangle[2] - imageRectangle[0];
                sourceSize[1] = imageRectangle[3] - imageRectangle[1];
                float xTranslateFactor = (float)imageRectangle[0] / (float)this.resultTexture.getImage().getWidth();
                float xStreachFactor = (float)this.resultTexture.getImage().getWidth() / (float)sourceSize[0];
                float yTranslateFactor = (float)imageRectangle[1] / (float)this.resultTexture.getImage().getHeight();
                float yStreachFactor = (float)this.resultTexture.getImage().getHeight() / (float)sourceSize[1];
                for (int j = 0; j < 3; ++j) {
                    sourceUVS[j].x = (sourceUVS[j].x - xTranslateFactor) * xStreachFactor;
                    sourceUVS[j].y = (sourceUVS[j].y - yTranslateFactor) * yStreachFactor;
                }
                AffineTransform affineTransform = textureHelper.createAffineTransform(sourceUVS, partImageUVS.toArray(new Vector2f[3]), sourceSize, targetSize);
                Image image = textureHelper.getSubimage(this.resultTexture.getImage(), imageRectangle[0], imageRectangle[1], imageRectangle[2], imageRectangle[3]);
                BufferedImage sourceImage = ImageToAwt.convert(image, false, true, 0);
                BufferedImage targetImage = new BufferedImage(targetSize[0], targetSize[1], sourceImage.getType());
                Graphics2D g = targetImage.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(sourceImage, affineTransform, null);
                g.dispose();
                Image output = imageLoader.load(targetImage, false);
                faceTextures.add(new TriangulatedTexture.TriangleTextureElement(faceIndex++, output, partImageUVS, false, blenderContext));
            }
            TriangulatedTexture triangulatedTexture = new TriangulatedTexture(faceTextures, blenderContext);
            triangulatedTexture.setKeepIdenticalTextures(false);
            this.resultTexture = triangulatedTexture.getResultTexture();
            this.resultUVS = basicUVS;
        }
    }

    private void computeImageRectangle(Vector2f[] triangleVertices, int[] result, int totalImageWidth, int totalImageHeight, BlenderContext blenderContext) {
        TextureHelper textureHelper = (TextureHelper)blenderContext.getHelper(TextureHelper.class);
        float minX = Math.min(triangleVertices[0].x, triangleVertices[1].x);
        minX = Math.min(minX, triangleVertices[2].x);
        float maxX = Math.max(triangleVertices[0].x, triangleVertices[1].x);
        maxX = Math.max(maxX, triangleVertices[2].x);
        float minY = Math.min(triangleVertices[0].y, triangleVertices[1].y);
        minY = Math.min(minY, triangleVertices[2].y);
        float maxY = Math.max(triangleVertices[0].y, triangleVertices[1].y);
        maxY = Math.max(maxY, triangleVertices[2].y);
        result[0] = textureHelper.getPixelPosition(minX, totalImageWidth);
        result[1] = textureHelper.getPixelPosition(minY, totalImageHeight);
        result[2] = textureHelper.getPixelPosition(maxX, totalImageWidth);
        result[3] = textureHelper.getPixelPosition(maxY, totalImageHeight);
    }

    public Texture getResultTexture() {
        return this.resultTexture;
    }

    public List<Vector2f> getResultUVS() {
        return this.resultUVS;
    }

    public int getTexturesCount() {
        return this.textureDatas.size();
    }

    public boolean hasGeneratedTextures() {
        if (this.textureDatas != null) {
            for (TextureData textureData : this.textureDatas) {
                if (!(textureData.texture instanceof GeneratedTexture)) continue;
                return true;
            }
        }
        return false;
    }

    private void merge(Texture2D target, Texture2D source) {
        if (target.getImage().getDepth() != source.getImage().getDepth()) {
            throw new IllegalArgumentException("Cannot merge images with different depths!");
        }
        Image sourceImage = source.getImage();
        Image targetImage = target.getImage();
        PixelInputOutput sourceIO = PixelIOFactory.getPixelIO(sourceImage.getFormat());
        PixelInputOutput targetIO = PixelIOFactory.getPixelIO(targetImage.getFormat());
        TexturePixel sourcePixel = new TexturePixel();
        TexturePixel targetPixel = new TexturePixel();
        int depth = target.getImage().getDepth() == 0 ? 1 : target.getImage().getDepth();
        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
            for (int x = 0; x < sourceImage.getWidth(); ++x) {
                for (int y = 0; y < sourceImage.getHeight(); ++y) {
                    sourceIO.read(sourceImage, layerIndex, sourcePixel, x, y);
                    targetIO.read(targetImage, layerIndex, targetPixel, x, y);
                    targetPixel.merge(sourcePixel);
                    targetIO.write(targetImage, layerIndex, targetPixel, x, y);
                }
            }
        }
    }

    private boolean isWithoutAlpha(TextureData textureData, BlenderContext blenderContext) {
        ColorBand colorBand = new ColorBand(textureData.textureStructure, blenderContext);
        if (!colorBand.hasTransparencies()) {
            int type = ((Number)textureData.textureStructure.getFieldValue("type")).intValue();
            if (type == 4) {
                return true;
            }
            if (type == 12) {
                int voronoiColorType = ((Number)textureData.textureStructure.getFieldValue("vn_coltype")).intValue();
                return voronoiColorType != 0;
            }
            if (type == 1) {
                int sType = ((Number)textureData.textureStructure.getFieldValue("stype")).intValue();
                return sType == 1;
            }
            if (type == 8) {
                Image image = textureData.texture.getImage();
                switch (image.getFormat()) {
                    case BGR8: 
                    case DXT1: 
                    case Luminance16: 
                    case Luminance16F: 
                    case Luminance32F: 
                    case Luminance8: 
                    case RGB10: 
                    case RGB111110F: 
                    case RGB16: 
                    case RGB16F: 
                    case RGB32F: 
                    case RGB565: 
                    case RGB8: {
                        return true;
                    }
                    case ABGR8: 
                    case DXT3: 
                    case DXT5: 
                    case Luminance16Alpha16: 
                    case Luminance16FAlpha16F: 
                    case Luminance8Alpha8: 
                    case RGBA16: 
                    case RGBA16F: 
                    case RGBA32F: 
                    case RGBA8: {
                        PixelInputOutput pixelInputOutput = PixelIOFactory.getPixelIO(image.getFormat());
                        TexturePixel pixel = new TexturePixel();
                        int depth = image.getDepth() == 0 ? 1 : image.getDepth();
                        for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                            for (int x = 0; x < image.getWidth(); ++x) {
                                for (int y = 0; y < image.getHeight(); ++y) {
                                    pixelInputOutput.read(image, layerIndex, pixel, x, y);
                                    if (!(pixel.alpha < 1.0f)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void scale(Texture2D texture, int width, int height) {
        boolean scaleRequired;
        boolean bl = scaleRequired = texture.getImage().getWidth() != width || texture.getImage().getHeight() != height;
        if (scaleRequired) {
            Image image = texture.getImage();
            BufferedImage sourceImage = ImageToAwt.convert(image, false, true, 0);
            int sourceWidth = sourceImage.getWidth();
            int sourceHeight = sourceImage.getHeight();
            BufferedImage targetImage = new BufferedImage(width, height, sourceImage.getType());
            Graphics2D g = targetImage.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(sourceImage, 0, 0, width, height, 0, 0, sourceWidth, sourceHeight, null);
            g.dispose();
            Image output = new ImageLoader().load(targetImage, false);
            image.setWidth(width);
            image.setHeight(height);
            image.setData(output.getData(0));
            image.setFormat(output.getFormat());
        }
    }

    private static class TextureData {
        public Texture texture;
        public TextureBlender textureBlender;
        public UVCoordinatesGenerator.UVCoordinatesType uvCoordinatesType;
        public UVProjectionGenerator.UVProjectionType projectionType;
        public Structure textureStructure;

        private TextureData() {
        }
    }
}

