/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.Track;
import com.jme3.math.Matrix4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.AnimationData;
import com.jme3.scene.plugins.blender.animations.ArmatureHelper;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArmatureModifier
extends Modifier {
    private static final Logger LOGGER = Logger.getLogger(ArmatureModifier.class.getName());
    private static final int MAXIMUM_WEIGHTS_PER_VERTEX = 4;
    private Skeleton skeleton;
    private Structure objectStructure;
    private Structure meshStructure;
    private AnimationData animationData;
    private Long meshOMA;

    public ArmatureModifier(Structure objectStructure, Structure modifierStructure, BlenderContext blenderContext) throws BlenderFileException {
        Structure meshStructure = ((Pointer)objectStructure.getFieldValue("data")).fetchData(blenderContext.getInputStream()).get(0);
        Pointer pDvert = (Pointer)meshStructure.getFieldValue("dvert");
        if (this.validate(modifierStructure, blenderContext) && pDvert.isNotNull()) {
            Pointer pArmatureObject = (Pointer)modifierStructure.getFieldValue("object");
            if (pArmatureObject.isNotNull()) {
                Pointer pAction;
                ArmatureHelper armatureHelper = (ArmatureHelper)blenderContext.getHelper(ArmatureHelper.class);
                Structure armatureObject = pArmatureObject.fetchData(blenderContext.getInputStream()).get(0);
                Structure armatureStructure = ((Pointer)armatureObject.getFieldValue("data")).fetchData(blenderContext.getInputStream()).get(0);
                ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                boolean fixUpAxis = blenderContext.getBlenderKey().isFixUpAxis();
                Matrix4f armatureObjectMatrix = objectHelper.getMatrix(armatureObject, "obmat", fixUpAxis);
                Matrix4f inverseMeshObjectMatrix = objectHelper.getMatrix(objectStructure, "imat", fixUpAxis);
                Matrix4f objectToArmatureTransformation = armatureObjectMatrix.multLocal(inverseMeshObjectMatrix);
                List<Structure> bonebase = ((Structure)armatureStructure.getFieldValue("bonebase")).evaluateListBase(blenderContext);
                ArrayList<Bone> bonesList = new ArrayList<Bone>();
                for (int i = 0; i < bonebase.size(); ++i) {
                    armatureHelper.buildBones(armatureObject.getOldMemoryAddress(), bonebase.get(i), null, bonesList, objectToArmatureTransformation, blenderContext);
                }
                bonesList.add(0, new Bone(""));
                Bone[] bones = bonesList.toArray(new Bone[bonesList.size()]);
                this.skeleton = new Skeleton(bones);
                blenderContext.setSkeleton(armatureObject.getOldMemoryAddress(), this.skeleton);
                this.objectStructure = objectStructure;
                this.meshStructure = meshStructure;
                this.meshOMA = meshStructure.getOldMemoryAddress();
                ArrayList<Animation> animations = new ArrayList<Animation>();
                List<FileBlockHeader> actionHeaders = blenderContext.getFileBlocks(1094909952);
                if (actionHeaders != null) {
                    for (FileBlockHeader header : actionHeaders) {
                        Structure actionStructure = header.getStructure(blenderContext);
                        String actionName = actionStructure.getName();
                        Track[] tracks = armatureHelper.getTracks(actionStructure, this.skeleton, blenderContext);
                        if (tracks == null || tracks.length <= 0) continue;
                        float maximumTrackLength = 0.0f;
                        for (BoneTrack boneTrack : tracks) {
                            float length = boneTrack.getLength();
                            if (!(length > maximumTrackLength)) continue;
                            maximumTrackLength = length;
                        }
                        Animation boneAnimation = new Animation(actionName, maximumTrackLength);
                        boneAnimation.setTracks(tracks);
                        animations.add(boneAnimation);
                    }
                }
                if ((pAction = (Pointer)objectStructure.getFieldValue("action")).isNotNull()) {
                    Structure actionStructure = pAction.fetchData(blenderContext.getInputStream()).get(0);
                    String actionName = actionStructure.getName();
                    Track[] tracks = armatureHelper.getTracks(actionStructure, this.skeleton, blenderContext);
                    if (tracks != null && tracks.length > 0) {
                        float maximumTrackLength = 0.0f;
                        for (BoneTrack boneTrack : tracks) {
                            float f = boneTrack.getLength();
                            if (!(f > maximumTrackLength)) continue;
                            maximumTrackLength = f;
                        }
                        Animation boneAnimation = new Animation(actionName, maximumTrackLength);
                        boneAnimation.setTracks(tracks);
                        animations.add(boneAnimation);
                    }
                }
                this.animationData = new AnimationData(this.skeleton, animations);
                for (Bone bone : bones) {
                    BoneContext boneContext;
                    Long boneOma;
                    if (bone.getName().length() <= 0 || (boneOma = (boneContext = blenderContext.getBoneContext(bone)).getBoneOma()) == null) continue;
                    blenderContext.setAnimData(boneOma, this.animationData);
                }
            } else {
                this.modifying = false;
            }
        }
    }

    @Override
    public Node apply(Node node, BlenderContext blenderContext) {
        if (this.invalid) {
            LOGGER.log(Level.WARNING, "Armature modifier is invalid! Cannot be applied to: {0}", node.getName());
        }
        if (this.animationData == null || this.skeleton == null) {
            return node;
        }
        List geomList = (List)blenderContext.getLoadedFeature(this.meshOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        MeshContext meshContext = blenderContext.getMeshContext(this.meshOMA);
        int[] bonesGroups = new int[]{0};
        for (Geometry geom : geomList) {
            int materialIndex = meshContext.getMaterialIndex(geom);
            Mesh mesh = geom.getMesh();
            try {
                VertexBuffer bindPoseBuffer;
                VertexBuffer[] buffers = this.readVerticesWeightsData(this.objectStructure, this.meshStructure, this.skeleton, materialIndex, bonesGroups, blenderContext);
                if (buffers == null) continue;
                mesh.setMaxNumWeights(bonesGroups[0]);
                mesh.setBuffer(buffers[0]);
                mesh.setBuffer(buffers[1]);
                VertexBuffer bindNormalBuffer = meshContext.getBindNormalBuffer(materialIndex);
                if (bindNormalBuffer != null) {
                    mesh.setBuffer(bindNormalBuffer);
                }
                if ((bindPoseBuffer = meshContext.getBindPoseBuffer(materialIndex)) != null) {
                    mesh.setBuffer(bindPoseBuffer);
                }
                mesh.getBuffer(VertexBuffer.Type.Position).setUsage(VertexBuffer.Usage.Stream);
                mesh.getBuffer(VertexBuffer.Type.Normal).setUsage(VertexBuffer.Usage.Stream);
                VertexBuffer verticesWeightsHW = new VertexBuffer(VertexBuffer.Type.HWBoneWeight);
                VertexBuffer verticesWeightsIndicesHW = new VertexBuffer(VertexBuffer.Type.HWBoneIndex);
                mesh.setBuffer(verticesWeightsHW);
                mesh.setBuffer(verticesWeightsIndicesHW);
            }
            catch (BlenderFileException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                this.invalid = true;
                return node;
            }
        }
        AnimControl control = new AnimControl(this.animationData.skeleton);
        List<Animation> animList = this.animationData.anims;
        if (animList != null && animList.size() > 0) {
            HashMap<String, Animation> anims = new HashMap<String, Animation>(animList.size());
            for (int i = 0; i < animList.size(); ++i) {
                Animation animation = animList.get(i);
                anims.put(animation.getName(), animation);
            }
            control.setAnimations(anims);
        }
        node.addControl(control);
        node.addControl(new SkeletonControl(this.animationData.skeleton));
        blenderContext.setNodeForSkeleton(this.skeleton, node);
        return node;
    }

    private VertexBuffer[] readVerticesWeightsData(Structure objectStructure, Structure meshStructure, Skeleton skeleton, int materialIndex, int[] bonesGroups, BlenderContext blenderContext) throws BlenderFileException {
        ArmatureHelper armatureHelper = (ArmatureHelper)blenderContext.getHelper(ArmatureHelper.class);
        Structure defBase = (Structure)objectStructure.getFieldValue("defbase");
        Map<Integer, Integer> groupToBoneIndexMap = armatureHelper.getGroupToBoneIndexMap(defBase, skeleton, blenderContext);
        MeshContext meshContext = blenderContext.getMeshContext(meshStructure.getOldMemoryAddress());
        return this.getBoneWeightAndIndexBuffer(meshStructure, meshContext.getVertexCount(materialIndex), bonesGroups, meshContext.getVertexReferenceMap(materialIndex), groupToBoneIndexMap, blenderContext);
    }

    private VertexBuffer[] getBoneWeightAndIndexBuffer(Structure meshStructure, int vertexListSize, int[] bonesGroups, Map<Integer, List<Integer>> vertexReferenceMap, Map<Integer, Integer> groupToBoneIndexMap, BlenderContext blenderContext) throws BlenderFileException {
        bonesGroups[0] = 0;
        Pointer pDvert = (Pointer)meshStructure.getFieldValue("dvert");
        FloatBuffer weightsFloatData = BufferUtils.createFloatBuffer(vertexListSize * 4);
        ByteBuffer indicesData = BufferUtils.createByteBuffer(vertexListSize * 4);
        if (pDvert.isNotNull()) {
            boolean warnAboutTooManyVertexWeights = false;
            List<Structure> dverts = pDvert.fetchData(blenderContext.getInputStream());
            int vertexIndex = 0;
            TreeMap<Float, Integer> weightToIndexMap = new TreeMap<Float, Integer>();
            for (Structure dvert : dverts) {
                List<Integer> vertexIndices = vertexReferenceMap.get(vertexIndex);
                if (vertexIndices != null) {
                    int totweight = ((Number)dvert.getFieldValue("totweight")).intValue();
                    Pointer pDW = (Pointer)dvert.getFieldValue("dw");
                    if (totweight > 0 && groupToBoneIndexMap != null) {
                        weightToIndexMap.clear();
                        int weightIndex = 0;
                        List<Structure> dw = pDW.fetchData(blenderContext.getInputStream());
                        for (Structure deformWeight : dw) {
                            Integer boneIndex = groupToBoneIndexMap.get(((Number)deformWeight.getFieldValue("def_nr")).intValue());
                            float weight = ((Number)deformWeight.getFieldValue("weight")).floatValue();
                            if (boneIndex == null || !(weight > 0.0f) && weightIndex <= 0) continue;
                            if (weightIndex < 4) {
                                if (weight == 0.0f) {
                                    boneIndex = 0;
                                }
                                for (Integer index : vertexIndices) {
                                    weightsFloatData.put(index * 4 + weightIndex, weight);
                                    indicesData.put(index * 4 + weightIndex, boneIndex.byteValue());
                                }
                                weightToIndexMap.put(Float.valueOf(weight), weightIndex);
                                bonesGroups[0] = Math.max(bonesGroups[0], weightIndex + 1);
                            } else if (weight > 0.0f) {
                                warnAboutTooManyVertexWeights = true;
                                Map.Entry lowestWeightAndIndex = weightToIndexMap.firstEntry();
                                if (lowestWeightAndIndex != null && ((Float)lowestWeightAndIndex.getKey()).floatValue() < weight) {
                                    for (Integer index : vertexIndices) {
                                        weightsFloatData.put(index * 4 + (Integer)lowestWeightAndIndex.getValue(), weight);
                                        indicesData.put(index * 4 + (Integer)lowestWeightAndIndex.getValue(), boneIndex.byteValue());
                                    }
                                    weightToIndexMap.remove(lowestWeightAndIndex.getKey());
                                    weightToIndexMap.put(Float.valueOf(weight), (Integer)lowestWeightAndIndex.getValue());
                                }
                            }
                            ++weightIndex;
                        }
                    } else {
                        for (Integer index : vertexIndices) {
                            weightsFloatData.put(index * 4, 0.0f);
                            indicesData.put(index * 4, (byte)0);
                        }
                    }
                }
                ++vertexIndex;
            }
            if (warnAboutTooManyVertexWeights) {
                LOGGER.log(Level.WARNING, "{0} has vertices with more than 4 weights assigned. The model may not behave as it should.", meshStructure.getName());
            }
        } else {
            for (List<Integer> vertexIndexList : vertexReferenceMap.values()) {
                for (Integer index : vertexIndexList) {
                    weightsFloatData.put(index * 4, 1.0f);
                    indicesData.put(index * 4, (byte)0);
                }
            }
        }
        bonesGroups[0] = Math.max(bonesGroups[0], 1);
        this.endBoneAssigns(vertexListSize, weightsFloatData);
        VertexBuffer verticesWeights = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        verticesWeights.setupData(VertexBuffer.Usage.CpuOnly, bonesGroups[0], VertexBuffer.Format.Float, weightsFloatData);
        VertexBuffer verticesWeightsIndices = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        verticesWeightsIndices.setupData(VertexBuffer.Usage.CpuOnly, bonesGroups[0], VertexBuffer.Format.UnsignedByte, indicesData);
        return new VertexBuffer[]{verticesWeights, verticesWeightsIndices};
    }

    private void endBoneAssigns(int vertCount, FloatBuffer weightsFloatData) {
        weightsFloatData.rewind();
        float[] weights = new float[4];
        for (int v = 0; v < vertCount; ++v) {
            float sum = 0.0f;
            for (int i = 0; i < 4; ++i) {
                weights[i] = weightsFloatData.get();
                sum += weights[i];
            }
            if (sum == 1.0f || sum == 0.0f) continue;
            weightsFloatData.position(weightsFloatData.position() - 4);
            float sumToB = 1.0f / sum;
            for (int i = 0; i < 4; ++i) {
                weightsFloatData.put(weights[i] * sumToB);
            }
        }
        weightsFloatData.rewind();
    }
}

