/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.scene.Geometry;
import com.jme3.scene.VertexBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshContext {
    private Map<Integer, Geometry> geometries = new HashMap<Integer, Geometry>();
    private Map<Integer, Map<Integer, List<Integer>>> vertexReferenceMap;
    private Map<Integer, VertexBuffer> bindPoseBuffer = new HashMap<Integer, VertexBuffer>();
    private Map<Integer, VertexBuffer> bindNormalBuffer = new HashMap<Integer, VertexBuffer>();

    public void putGeometry(Integer materialIndex, Geometry geometry) {
        this.geometries.put(materialIndex, geometry);
    }

    public int getVertexCount(int materialIndex) {
        return this.geometries.get(materialIndex).getVertexCount();
    }

    public int getMaterialIndex(Geometry geometry) {
        for (Map.Entry<Integer, Geometry> entry : this.geometries.entrySet()) {
            if (!entry.getValue().equals(geometry)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Cannot find material index for the given geometry: " + geometry);
    }

    public Map<Integer, List<Integer>> getVertexReferenceMap(int materialIndex) {
        return this.vertexReferenceMap.get(materialIndex);
    }

    public void setVertexReferenceMap(Map<Integer, Map<Integer, List<Integer>>> vertexReferenceMap) {
        this.vertexReferenceMap = vertexReferenceMap;
    }

    public void setBindNormalBuffer(int materialIndex, VertexBuffer bindNormalBuffer) {
        this.bindNormalBuffer.put(materialIndex, bindNormalBuffer);
    }

    public VertexBuffer getBindNormalBuffer(int materialIndex) {
        return this.bindNormalBuffer.get(materialIndex);
    }

    public void setBindPoseBuffer(int materialIndex, VertexBuffer bindPoseBuffer) {
        this.bindPoseBuffer.put(materialIndex, bindPoseBuffer);
    }

    public VertexBuffer getBindPoseBuffer(int materialIndex) {
        return this.bindPoseBuffer.get(materialIndex);
    }
}

