/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.file;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.Field;
import com.jme3.scene.plugins.blender.file.Pointer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure
implements Cloneable {
    private BlenderContext blenderContext;
    private transient Long oldMemoryAddress;
    private String type;
    private Field[] fields;

    private Structure(Structure structure, BlenderContext blenderContext) throws CloneNotSupportedException {
        this.type = structure.type;
        this.fields = new Field[structure.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = (Field)structure.fields[i].clone();
        }
        this.blenderContext = blenderContext;
        this.oldMemoryAddress = structure.oldMemoryAddress;
    }

    public Structure(BlenderInputStream inputStream, String[] names, String[] types, BlenderContext blenderContext) throws BlenderFileException {
        int nameIndex = inputStream.readShort();
        this.type = types[nameIndex];
        this.blenderContext = blenderContext;
        int fieldsAmount = inputStream.readShort();
        if (fieldsAmount < 0) {
            throw new BlenderFileException("The amount of fields of " + this.type + " structure cannot be negative!");
        }
        if (fieldsAmount > 0) {
            this.fields = new Field[fieldsAmount];
            for (int i = 0; i < fieldsAmount; ++i) {
                int typeIndex = inputStream.readShort();
                nameIndex = inputStream.readShort();
                this.fields[i] = new Field(names[nameIndex], types[typeIndex], blenderContext);
            }
        }
        this.oldMemoryAddress = -1L;
    }

    public void fill(BlenderInputStream inputStream) throws BlenderFileException {
        int position = inputStream.getPosition();
        inputStream.setPosition(position - 8 - inputStream.getPointerSize());
        this.oldMemoryAddress = inputStream.readPointer();
        inputStream.setPosition(position);
        for (Field field : this.fields) {
            field.fill(inputStream);
        }
    }

    public Object getFieldValue(String fieldName) {
        for (Field field : this.fields) {
            if (!field.name.equalsIgnoreCase(fieldName)) continue;
            return field.value;
        }
        return null;
    }

    public Object getFlatFieldValue(String fieldName) {
        for (Field field : this.fields) {
            Object value = field.value;
            if (field.name.equalsIgnoreCase(fieldName)) {
                return value;
            }
            if (!(value instanceof Structure) || (value = ((Structure)value).getFlatFieldValue(fieldName)) == null) continue;
            return value;
        }
        return null;
    }

    public List<Structure> evaluateListBase(BlenderContext blenderContext) throws BlenderFileException {
        if (!"ListBase".equals(this.type)) {
            throw new IllegalStateException("This structure is not of type: 'ListBase'");
        }
        Pointer first = (Pointer)this.getFieldValue("first");
        Pointer last = (Pointer)this.getFieldValue("last");
        long currentAddress = 0L;
        long lastAddress = last.getOldMemoryAddress();
        LinkedList<Structure> result = new LinkedList<Structure>();
        while (currentAddress != lastAddress) {
            currentAddress = first.getOldMemoryAddress();
            Structure structure = first.fetchData(blenderContext.getInputStream()).get(0);
            result.add(structure);
            first = (Pointer)structure.getFlatFieldValue("next");
        }
        return result;
    }

    public String getType() {
        return this.type;
    }

    public int getFieldsAmount() {
        return this.fields.length;
    }

    public String getFieldFullName(int fieldIndex) {
        return this.fields[fieldIndex].getFullName();
    }

    public String getFieldType(int fieldIndex) {
        return this.fields[fieldIndex].type;
    }

    public Long getOldMemoryAddress() {
        if (this.oldMemoryAddress == -1L) {
            throw new IllegalStateException("Call the 'fill' method and fill the structure with data first!");
        }
        return this.oldMemoryAddress;
    }

    public String getName() {
        Object fieldValue = this.getFieldValue("ID");
        if (fieldValue instanceof Structure) {
            Structure id2 = (Structure)fieldValue;
            return id2 == null ? null : id2.getFieldValue("name").toString().substring(2);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("struct ").append(this.type).append(" {\n");
        for (int i = 0; i < this.fields.length; ++i) {
            result.append(this.fields[i].toString()).append('\n');
        }
        return result.append('}').toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return new Structure(this, this.blenderContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DataType {
        CHARACTER,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        VOID,
        STRUCTURE,
        POINTER;

        private static final Map<String, DataType> PRIMARY_TYPES;

        public static DataType getDataType(String type, BlenderContext blenderContext) throws BlenderFileException {
            DataType result = PRIMARY_TYPES.get(type);
            if (result != null) {
                return result;
            }
            if (blenderContext.getDnaBlockData().hasStructure(type)) {
                return STRUCTURE;
            }
            throw new BlenderFileException("Unknown data type: " + type);
        }

        static {
            PRIMARY_TYPES = new HashMap<String, DataType>(10);
            PRIMARY_TYPES.put("char", CHARACTER);
            PRIMARY_TYPES.put("uchar", CHARACTER);
            PRIMARY_TYPES.put("short", SHORT);
            PRIMARY_TYPES.put("ushort", SHORT);
            PRIMARY_TYPES.put("int", INTEGER);
            PRIMARY_TYPES.put("long", LONG);
            PRIMARY_TYPES.put("ulong", LONG);
            PRIMARY_TYPES.put("uint64_t", LONG);
            PRIMARY_TYPES.put("float", FLOAT);
            PRIMARY_TYPES.put("double", DOUBLE);
            PRIMARY_TYPES.put("void", VOID);
        }
    }
}

